/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import java.util.List;
import java.util.Map;

public interface IRestfulClientFactory {
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 10000;
    public static final ServerValidationModeEnum DEFAULT_SERVER_VALIDATION_MODE = ServerValidationModeEnum.ONCE;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_POOL_MAX = 20;
    public static final int DEFAULT_POOL_MAX_PER_ROUTE = 20;

    public int getConnectionRequestTimeout();

    public int getConnectTimeout();

    public IHttpClient getHttpClient(StringBuilder var1, Map<String, List<String>> var2, String var3, RequestTypeEnum var4, List<Header> var5);

    @Deprecated
    public ServerValidationModeEnum getServerValidationModeEnum();

    public ServerValidationModeEnum getServerValidationMode();

    public int getSocketTimeout();

    public int getPoolMaxTotal();

    public int getPoolMaxPerRoute();

    public <T extends IRestfulClient> T newClient(Class<T> var1, String var2);

    public IGenericClient newGenericClient(String var1);

    public void setConnectionRequestTimeout(int var1);

    public void setConnectTimeout(int var1);

    public <T> void setHttpClient(T var1);

    public void setProxy(String var1, Integer var2);

    public void setProxyCredentials(String var1, String var2);

    @Deprecated
    public void setServerValidationModeEnum(ServerValidationModeEnum var1);

    public void setServerValidationMode(ServerValidationModeEnum var1);

    public void setSocketTimeout(int var1);

    public void setPoolMaxTotal(int var1);

    public void setPoolMaxPerRoute(int var1);

    public void validateServerBase(String var1, IHttpClient var2, BaseClient var3);

    public void validateServerBaseIfConfiguredToDoSo(String var1, IHttpClient var2, BaseClient var3);
}

