/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;

public class StrictErrorHandler
implements IParserErrorHandler {
    @Override
    public void unknownElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException("Unknown element '" + theElementName + "' found during parse");
    }

    @Override
    public void unknownAttribute(IParserErrorHandler.IParseLocation theLocation, String theAttributeName) {
        throw new DataFormatException("Unknown attribute '" + theAttributeName + "' found during parse");
    }

    @Override
    public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException("Multiple repetitions of non-repeatable element '" + theElementName + "' found during parse");
    }

    @Override
    public void containedResourceWithNoId(IParserErrorHandler.IParseLocation theLocation) {
        throw new DataFormatException("Resource has contained child resource with no ID");
    }

    @Override
    public void unknownReference(IParserErrorHandler.IParseLocation theLocation, String theReference) {
        throw new DataFormatException("Resource has invalid reference: " + theReference);
    }

    @Override
    public void missingRequiredElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        StringBuilder b = new StringBuilder();
        b.append("Resource is missing required element '");
        b.append(theElementName);
        b.append("'");
        if (theLocation != null) {
            b.append(" in parent element '");
            b.append(theLocation.getParentElementName());
            b.append("'");
        }
        throw new DataFormatException(b.toString());
    }
}

