/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.browsermob.proxy.http.BrowserMobHttpClient;
import org.browsermob.proxy.util.Log;

public class HttpClientInterrupter {
    private static final Log LOG = new Log();
    private static Set<BrowserMobHttpClient> clients = new CopyOnWriteArraySet<BrowserMobHttpClient>();

    public static void watch(BrowserMobHttpClient client) {
        clients.add(client);
    }

    public static void release(BrowserMobHttpClient client) {
        clients.remove(client);
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (BrowserMobHttpClient client : clients) {
                        try {
                            client.checkTimeout();
                        }
                        catch (Exception e) {
                            LOG.severe("Unexpected problem while checking timeout on a client", e);
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }, "HttpClientInterrupter Thread");
        thread.setDaemon(true);
        thread.start();
    }
}

