/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.conn.scheme.HostNameResolver;
import org.browsermob.proxy.http.RequestInfo;
import org.browsermob.proxy.util.Log;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public class BrowserMobHostNameResolver
implements HostNameResolver {
    private static final Log LOG = new Log();
    public static ThreadLocal<Boolean> fakeSlow = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Map<String, String> remappings = new ConcurrentHashMap<String, String>();
    private Map<String, List<String>> reverseMapping = new ConcurrentHashMap<String, List<String>>();
    private Cache cache;
    private Resolver resolver;

    public BrowserMobHostNameResolver(Cache cache) {
        this.cache = cache;
        try {
            this.resolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public InetAddress resolve(String hostname) throws IOException {
        String remapping = this.remappings.get(hostname);
        if (remapping != null) {
            hostname = remapping;
        }
        try {
            return Address.getByAddress(hostname);
        }
        catch (UnknownHostException e) {
            boolean isCached = this.isCached(hostname);
            Lookup lookup = new Lookup(Name.fromString(hostname), 1);
            lookup.setCache(this.cache);
            lookup.setResolver(this.resolver);
            Date start = new Date();
            Record[] records = lookup.run();
            if (fakeSlow.get().booleanValue()) {
                fakeSlow.set(false);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            Date end = new Date();
            if (records == null || records.length == 0) {
                throw new UnknownHostException(hostname);
            }
            ARecord a = (ARecord)records[0];
            InetAddress addr = InetAddress.getByAddress(hostname, a.getAddress().getAddress());
            if (!isCached) {
                RequestInfo.get().dns(start, end, addr.getHostAddress());
            } else {
                RequestInfo.get().dns(end, end, addr.getHostAddress());
            }
            return addr;
        }
    }

    public void remap(String source, String target) {
        this.remappings.put(source, target);
        List<String> list = this.reverseMapping.get(target);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(source);
        this.reverseMapping.put(target, list);
    }

    public String remapping(String host) {
        return this.remappings.get(host);
    }

    public List<String> original(String host) {
        return this.reverseMapping.get(host);
    }

    public void clearCache() {
        this.cache.clearCache();
    }

    public void setCacheTimeout(int timeout) {
        this.cache.setMaxCache(timeout);
    }

    public boolean isCached(String hostname) throws TextParseException {
        return this.cache.lookupRecords(Name.fromString(hostname), 255, 3).isSuccessful();
    }
}

