/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.bricks;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.sitebricks.At;
import com.google.sitebricks.client.transport.Json;
import com.google.sitebricks.headless.Reply;
import com.google.sitebricks.headless.Request;
import com.google.sitebricks.headless.Service;
import com.google.sitebricks.http.Delete;
import com.google.sitebricks.http.Get;
import com.google.sitebricks.http.Post;
import com.google.sitebricks.http.Put;
import java.util.Hashtable;
import java.util.Map;
import org.browsermob.core.har.Har;
import org.browsermob.proxy.ProxyManager;
import org.browsermob.proxy.ProxyServer;

@At(value="/proxy")
@Service
public class ProxyResource {
    private ProxyManager proxyManager;

    @Inject
    public ProxyResource(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Post
    public Reply<ProxyDescriptor> newProxy(Request request) throws Exception {
        String httpProxy = request.param("httpProxy");
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (httpProxy != null) {
            options.put("httpProxy", httpProxy);
        }
        String paramPort = request.param("port");
        int port = 0;
        if (paramPort != null) {
            port = Integer.parseInt(paramPort);
            ProxyServer proxy = this.proxyManager.create(options, port);
        } else {
            ProxyServer proxy = this.proxyManager.create(options);
            port = proxy.getPort();
        }
        return Reply.with((Object)new ProxyDescriptor(port)).as(Json.class);
    }

    @Get
    @At(value="/:port/har")
    public Reply<Har> getHar(@Named(value="port") int port) {
        ProxyServer proxy = this.proxyManager.get(port);
        Har har = proxy.getHar();
        return Reply.with((Object)har).as(Json.class);
    }

    @Put
    @At(value="/:port/har")
    public Reply<?> newHar(@Named(value="port") int port, Request request) {
        String initialPageRef = request.param("initialPageRef");
        ProxyServer proxy = this.proxyManager.get(port);
        Har oldHar = proxy.newHar(initialPageRef);
        String captureHeaders = request.param("captureHeaders");
        String captureContent = request.param("captureContent");
        proxy.setCaptureHeaders(Boolean.parseBoolean(captureHeaders));
        proxy.setCaptureContent(Boolean.parseBoolean(captureContent));
        if (oldHar != null) {
            return Reply.with((Object)oldHar).as(Json.class);
        }
        return Reply.saying().noContent();
    }

    @Put
    @At(value="/:port/har/pageRef")
    public Reply<?> setPage(@Named(value="port") int port, Request request) {
        String pageRef = request.param("pageRef");
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.newPage(pageRef);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/blacklist")
    public Reply<?> blacklist(@Named(value="port") int port, Request request) {
        String blacklist = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.blacklistRequests(blacklist, responseCode);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/whitelist")
    public Reply<?> whitelist(@Named(value="port") int port, Request request) {
        String regex = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.whitelistRequests(regex.split(","), responseCode);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/headers")
    public Reply<?> updateHeaders(@Named(value="port") int port, Request request) {
        ProxyServer proxy = this.proxyManager.get(port);
        Map headers = (Map)request.read(Map.class).as(Json.class);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            proxy.addHeader(key, value);
        }
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/limit")
    public Reply<?> limit(@Named(value="port") int port, Request request) {
        String latency;
        String downstreamKbps;
        ProxyServer proxy = this.proxyManager.get(port);
        String upstreamKbps = request.param("upstreamKbps");
        if (upstreamKbps != null) {
            try {
                proxy.setUpstreamKbps(Integer.parseInt(upstreamKbps));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((downstreamKbps = request.param("downstreamKbps")) != null) {
            try {
                proxy.setDownstreamKbps(Integer.parseInt(downstreamKbps));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((latency = request.param("latency")) != null) {
            try {
                proxy.setLatency(Integer.parseInt(latency));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port")
    public Reply<?> delete(@Named(value="port") int port) throws Exception {
        this.proxyManager.delete(port);
        return Reply.saying().ok();
    }

    private int parseResponseCode(String response) {
        int responseCode = 200;
        if (response != null) {
            try {
                responseCode = Integer.parseInt(response);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return responseCode;
    }

    public static class ProxyDescriptor {
        private int port;

        public ProxyDescriptor() {
        }

        public ProxyDescriptor(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

