/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.memoize;

import aQute.bnd.memoize.CloseableMemoize;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

class CloseableMemoizingSupplier<T extends AutoCloseable>
implements CloseableMemoize<T> {
    private final StampedLock lock;
    private volatile boolean initial;
    private T memoized;

    CloseableMemoizingSupplier(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        this.memoized = () -> {
            AutoCloseable result = (AutoCloseable)supplier.get();
            this.memoized = result;
            this.initial = false;
            return result;
        };
        this.initial = true;
        this.lock = new StampedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.initial) {
            long stamp = this.lock.writeLock();
            try {
                T t = this.initial();
                return t;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
        return CloseableMemoizingSupplier.value(this.memoized);
    }

    private T initial() {
        if (this.initial) {
            AutoCloseable result = (AutoCloseable)((Supplier)this.memoized).get();
            return (T)CloseableMemoizingSupplier.value(result);
        }
        return CloseableMemoizingSupplier.value(this.memoized);
    }

    private static <T extends AutoCloseable> T value(T value) {
        if (value == null) {
            throw new IllegalStateException("closed");
        }
        return value;
    }

    @Override
    public T peek() {
        if (this.initial) {
            return null;
        }
        return this.memoized;
    }

    @Override
    public boolean isPresent() {
        return !this.initial && this.memoized != null;
    }

    @Override
    public boolean isClosed() {
        return !this.initial && this.memoized == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (!this.isClosed()) {
            T closeable;
            long stamp = this.lock.writeLock();
            try {
                if (this.initial) {
                    this.memoized = null;
                    this.initial = false;
                    return;
                }
                closeable = this.memoized;
                if (closeable == null) {
                    return;
                }
                this.memoized = null;
                this.initial = false;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
            closeable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableMemoize<T> accept(Consumer<? super T> consumer) {
        long stamp;
        Objects.requireNonNull(consumer);
        if (this.initial && (stamp = this.lock.tryWriteLock()) != 0L) {
            try {
                T value = this.initial();
                stamp = this.lock.tryConvertToReadLock(stamp);
                consumer.accept(value);
            }
            finally {
                this.lock.unlock(stamp);
            }
            return this;
        }
        stamp = this.lock.readLock();
        try {
            T value = CloseableMemoizingSupplier.value(this.memoized);
            consumer.accept(value);
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableMemoize<T> ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            Objects.requireNonNull(consumer);
            long stamp = this.lock.readLock();
            try {
                T value = this.memoized;
                if (value != null) {
                    consumer.accept(value);
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return this;
    }

    public String toString() {
        return this.initial ? "<empty>" : Objects.toString(this.memoized, "<closed>");
    }

    static interface InitialSupplier<S extends AutoCloseable>
    extends Supplier<S>,
    AutoCloseable {
        @Override
        default public void close() {
        }
    }
}

