/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import ar.com.fdvs.dj.core.layout.LayoutException;
import ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabMeasure;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DJLabel;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.CrosstabColumnBuilder;
import ar.com.fdvs.dj.domain.builders.CrosstabRowBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import java.util.Comparator;

public class CrosstabBuilder {
    private DJCrosstab crosstab = new DJCrosstab();
    int cellHeight = -1;
    int cellWidth = -1;
    int columnHeaderHeight = -1;
    int rowHeaderWidth = -1;
    private final int DEFAULT_ROW_HEADER_WIDTH = 90;
    private final int DEFAULT_COLUMN_HEADER_HEIGHT = 25;
    private final int DEFAULT_CELL_HEIGHT = 20;
    private final int DEFAULT_CELL_WIDTH = 90;

    public DJCrosstab build() {
        if (this.crosstab.getMeasures().isEmpty()) {
            throw new LayoutException("Crosstabs must have at least one measure");
        }
        if (this.crosstab.getColumns().isEmpty()) {
            throw new LayoutException("Crosstabs must have at least one column");
        }
        if (this.crosstab.getRows().isEmpty()) {
            throw new LayoutException("Crosstabs must have at least one row");
        }
        for (DJCrosstabColumn col : this.crosstab.getColumns()) {
            if (col.getWidth() == -1 && this.cellWidth != -1) {
                col.setWidth(this.cellWidth);
            }
            if (col.getWidth() == -1) {
                col.setWidth(90);
            }
            if (col.getHeaderHeight() == -1 && this.columnHeaderHeight != -1) {
                col.setHeaderHeight(this.columnHeaderHeight);
            }
            if (col.getHeaderHeight() != -1) continue;
            col.setHeaderHeight(25);
        }
        for (DJCrosstabRow row : this.crosstab.getRows()) {
            if (row.getHeight() == -1 && this.cellHeight != -1) {
                row.setHeight(this.cellHeight);
            }
            if (row.getHeight() == -1) {
                row.setHeight(20);
            }
            if (row.getHeaderWidth() == -1 && this.rowHeaderWidth != -1) {
                row.setHeaderWidth(this.rowHeaderWidth);
            }
            if (row.getHeaderWidth() != -1) continue;
            row.setHeaderWidth(90);
        }
        return this.crosstab;
    }

    public CrosstabBuilder setHeight(int height) {
        this.crosstab.setHeight(height);
        return this;
    }

    public CrosstabBuilder setWidth(int width) {
        this.crosstab.setWidth(width);
        return this;
    }

    public CrosstabBuilder setHeaderStyle(Style headerStyle) {
        this.crosstab.setHeaderStyle(headerStyle);
        return this;
    }

    public CrosstabBuilder setDatasource(String expression, int origin, int type) {
        DJDataSource datasource = new DJDataSource(expression, origin, type);
        this.crosstab.setDatasource(datasource);
        return this;
    }

    public CrosstabBuilder setDatasource(String expression, int origin, int type, boolean preSorted) {
        DJDataSource datasource = new DJDataSource(expression, origin, type);
        datasource.setPreSorted(preSorted);
        this.crosstab.setDatasource(datasource);
        return this;
    }

    public CrosstabBuilder useMainReportDatasource(boolean preSorted) {
        DJDataSource datasource = new DJDataSource("ds", 2, 10);
        datasource.setPreSorted(preSorted);
        this.crosstab.setDatasource(datasource);
        return this;
    }

    public CrosstabBuilder setUseFullWidth(boolean useFullWidth) {
        this.crosstab.setUseFullWidth(useFullWidth);
        return this;
    }

    public CrosstabBuilder setIgnoreWidth(boolean ignoreWidth) {
        this.crosstab.setIgnoreWidth(ignoreWidth);
        return this;
    }

    public CrosstabBuilder setCellBorder(Border cellBorder) {
        this.crosstab.setCellBorder(cellBorder);
        return this;
    }

    public CrosstabBuilder addMeasure(String property, String className, DJCalculation operation, String title, Style style) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, operation, title);
        measure.setStyle(style);
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addMeasure(String property, String className, DJCalculation operation, String title, Style style, boolean isPercentage) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, operation, title);
        measure.setStyle(style);
        measure.setIsPercentage(isPercentage);
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addMeasure(DJCrosstabMeasure measure) {
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addInvisibleMeasure(String property, String className, String title) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, DJCalculation.NOTHING, title);
        measure.setVisible(false);
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addRow(DJCrosstabRow row) {
        this.crosstab.getRows().add(row);
        return this;
    }

    public CrosstabBuilder addColumn(DJCrosstabColumn col) {
        this.crosstab.getColumns().add(col);
        return this;
    }

    public CrosstabBuilder setColorScheme(int colorScheme) {
        this.crosstab.setColorScheme(colorScheme);
        return this;
    }

    public CrosstabBuilder setColorScheme(CrossTabColorShema colorScheme) {
        this.crosstab.setCtColorScheme(colorScheme);
        return this;
    }

    public CrosstabBuilder setMainHeaderTitle(String title) {
        this.crosstab.setMainHeaderTitle(title);
        this.crosstab.setAutomaticTitle(false);
        return this;
    }

    public CrosstabBuilder setAutomaticTitle(boolean bool) {
        this.crosstab.setAutomaticTitle(bool);
        return this;
    }

    public CrosstabBuilder setBottomSpace(int bottomSpace) {
        this.crosstab.setBottomSpace(bottomSpace);
        return this;
    }

    public CrosstabBuilder setTopSpace(int topSpace) {
        this.crosstab.setTopSpace(topSpace);
        return this;
    }

    public CrosstabBuilder addColumn(String title, String property, String className, boolean showTotal) {
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).build();
        this.addColumn(col);
        return this;
    }

    public CrosstabBuilder addColumn(String title, String property, String className, boolean showTotal, String totalLegend) {
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty(property, className).setShowTotals(showTotal).setTotalLegend(totalLegend).setTitle(title).build();
        this.addColumn(col);
        return this;
    }

    public CrosstabBuilder addColumn(String title, String property, String className, boolean showTotal, String totalLegend, Comparator comparator) {
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty(property, className).setShowTotals(showTotal).setTotalLegend(totalLegend).setTitle(title).setComparator(comparator).build();
        this.addColumn(col);
        return this;
    }

    public CrosstabBuilder addColumn(String title, String property, String className, boolean showTotal, Style headerStyle, Style totalStyle, Style totalHeaderStyle) {
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).setHeaderStyle(headerStyle).setTotalHeaderStyle(totalHeaderStyle).setTotalStyle(totalStyle).build();
        this.addColumn(col);
        return this;
    }

    public CrosstabBuilder addColumn(String title, String property, String className, boolean showTotal, Style headerStyle, Style totalStyle, Style totalHeaderStyle, Comparator comparator) {
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).setHeaderStyle(headerStyle).setTotalHeaderStyle(totalHeaderStyle).setTotalStyle(totalStyle).setComparator(comparator).build();
        this.addColumn(col);
        return this;
    }

    public CrosstabBuilder addRow(String title, String property, String className, boolean showTotal) {
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).build();
        this.addRow(row);
        return this;
    }

    public CrosstabBuilder addRow(String title, String property, String className, boolean showTotal, String totalLegend) {
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty(property, className).setTotalLegend(totalLegend).setShowTotals(showTotal).setTitle(title).build();
        this.addRow(row);
        return this;
    }

    public CrosstabBuilder addRow(String title, String property, String className, boolean showTotal, String totalLegend, Comparator comparator) {
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty(property, className).setTotalLegend(totalLegend).setShowTotals(showTotal).setTitle(title).setComparator(comparator).build();
        this.addRow(row);
        return this;
    }

    public CrosstabBuilder addRow(String title, String property, String className, boolean showTotal, Style headerStyle, Style totalStyle, Style totalHeaderStyle) {
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).setHeaderStyle(headerStyle).setTotalHeaderStyle(totalHeaderStyle).setTotalStyle(totalStyle).build();
        this.addRow(row);
        return this;
    }

    public CrosstabBuilder addRow(String title, String property, String className, boolean showTotal, Style headerStyle, Style totalStyle, Style totalHeaderStyle, Comparator comparator) {
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty(property, className).setShowTotals(showTotal).setTitle(title).setHeaderStyle(headerStyle).setTotalHeaderStyle(totalHeaderStyle).setTotalStyle(totalStyle).setComparator(comparator).build();
        this.addRow(row);
        return this;
    }

    public CrosstabBuilder setRowStyles(Style headerStyle, Style totalStyle, Style totalHeaderStyle) {
        this.crosstab.setRowHeaderStyle(headerStyle);
        this.crosstab.setRowTotalheaderStyle(totalHeaderStyle);
        this.crosstab.setRowTotalStyle(totalStyle);
        return this;
    }

    public CrosstabBuilder setColumnStyles(Style headerStyle, Style totalStyle, Style totalHeaderStyle) {
        this.crosstab.setColumnHeaderStyle(headerStyle);
        this.crosstab.setColumnTotalheaderStyle(totalHeaderStyle);
        this.crosstab.setColumnTotalStyle(totalStyle);
        return this;
    }

    public CrosstabBuilder setCellWidth(int width) {
        this.cellWidth = width;
        return this;
    }

    public CrosstabBuilder setColumnHeaderHeight(int height) {
        this.columnHeaderHeight = height;
        return this;
    }

    public CrosstabBuilder setCellDimension(int height, int width) {
        this.setCellHeight(height);
        this.setCellWidth(width);
        return this;
    }

    public CrosstabBuilder setCellHeight(int height) {
        this.cellHeight = height;
        return this;
    }

    public CrosstabBuilder setRowHeaderWidth(int width) {
        this.rowHeaderWidth = width;
        return this;
    }

    public CrosstabBuilder setCaption(DJLabel caption) {
        this.crosstab.setCaption(caption);
        return this;
    }

    public CrosstabBuilder addMeasure(String property, String className, DJCalculation operation, String title, Style style, DJValueFormatter valueFormatter) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, operation, title);
        measure.setStyle(style);
        measure.setValueFormatter(valueFormatter);
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addMeasure(String property, String className, DJCalculation operation, String title, Style style, DJValueFormatter valueFormatter, boolean isPercentage) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, operation, title);
        measure.setStyle(style);
        measure.setValueFormatter(valueFormatter);
        measure.setIsPercentage(isPercentage);
        this.crosstab.getMeasures().add(measure);
        return this;
    }

    public CrosstabBuilder addMeasure(String property, String className, DJCalculation operation, String title, Style style, DJValueFormatter valueFormatter, DJCRosstabMeasurePrecalculatedTotalProvider totalProvider) {
        DJCrosstabMeasure measure = new DJCrosstabMeasure(property, className, operation, title);
        measure.setStyle(style);
        measure.setValueFormatter(valueFormatter);
        measure.setPrecalculatedTotalProvider(totalProvider);
        this.crosstab.getMeasures().add(measure);
        return this;
    }
}

