/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.LastResourceRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.storage.solr.SolrUtil;

public class SolrResource
implements OnePhaseResource {
    private static Log log = LogFactory.getLog(SolrResource.class);
    protected SolrServer solrServer;
    protected ThreadLocal<Map<String, SolrInputDocument>> addedDocs;
    protected ThreadLocal<List<String>> deletedDocs;

    public SolrResource(SolrServer solrServer) {
        this.solrServer = solrServer;
        this.addedDocs = new ThreadLocal();
        this.deletedDocs = new ThreadLocal();
        this.clear();
    }

    protected void init() {
        LastResourceRecord lastResourceRecord = new LastResourceRecord((OnePhaseResource)this);
        BasicAction.Current().add((AbstractRecord)lastResourceRecord);
    }

    protected void close() {
    }

    public Map<String, SolrInputDocument> getAddedDocs() {
        Map<String, SolrInputDocument> result = this.addedDocs.get();
        if (result == null) {
            result = new HashMap<String, SolrInputDocument>();
            this.addedDocs.set(result);
        }
        return result;
    }

    public List<String> getDeletedDocs() {
        List<String> result = this.deletedDocs.get();
        if (result == null) {
            result = new ArrayList<String>();
            this.deletedDocs.set(result);
        }
        return result;
    }

    public void clear() {
        this.addedDocs.set(new HashMap());
        this.deletedDocs.set(new ArrayList());
    }

    public void addDoc(String id, SolrInputDocument doc) {
        this.getAddedDocs().put(id, doc);
    }

    public SolrInputDocument getAddedDoc(String id) {
        SolrInputDocument result = this.getAddedDocs().get(id);
        return result;
    }

    public Collection<String> getAddedDocIds() {
        Set<String> result = this.getAddedDocs().keySet();
        return result;
    }

    public void deleteDoc(String docId) {
        this.getDeletedDocs().add(docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commit() {
        try {
            SolrResource solrResource = this;
            synchronized (solrResource) {
                List<String> ids;
                Collection<SolrInputDocument> docs = this.getAddedDocs().values();
                if (!docs.isEmpty()) {
                    this.addAllSolrfield(docs);
                    this.solrServer.add(docs);
                }
                if (!(ids = this.getDeletedDocs()).isEmpty()) {
                    this.solrServer.deleteById(ids);
                }
                this.solrServer.commit();
            }
            this.clear();
            return 7;
        }
        catch (Exception eee) {
            log.error((Object)"Error commit solr", (Throwable)eee);
            return 8;
        }
    }

    protected void addAllSolrfield(Collection<SolrInputDocument> docs) {
        for (SolrInputDocument doc : docs) {
            ArrayList fieldnames = new ArrayList(doc.getFieldNames());
            for (String solrFqFieldName : fieldnames) {
                if (solrFqFieldName.startsWith("#")) continue;
                String fqfieldName = StringUtils.substringBeforeLast((String)solrFqFieldName, (String)"_");
                String solrAllFieldName = "#all." + WikittyUtil.getFieldNameFromFQFieldName((String)solrFqFieldName);
                String solrFulltextAllFieldName = "#ft.all." + WikittyUtil.getFieldNameFromFQFieldName((String)fqfieldName);
                String solrFqFieldNameSortable = solrFqFieldName + "_sortable";
                doc.remove((Object)solrAllFieldName);
                doc.remove((Object)solrFulltextAllFieldName);
                doc.remove((Object)solrFqFieldNameSortable);
            }
            for (String solrFqFieldName : fieldnames) {
                if (solrFqFieldName.startsWith("#") || solrFqFieldName.endsWith("_sortable")) continue;
                Object fieldValue = doc.getFieldValue(solrFqFieldName);
                String fqfieldName = StringUtils.substringBeforeLast((String)solrFqFieldName, (String)"_");
                String solrAllFieldName = "#all." + WikittyUtil.getFieldNameFromFQFieldName((String)solrFqFieldName);
                String solrFulltextAllFieldName = "#ft.all." + WikittyUtil.getFieldNameFromFQFieldName((String)fqfieldName);
                String solrFqFieldNameSortable = solrFqFieldName + "_sortable";
                doc.addField(solrAllFieldName, fieldValue);
                doc.addField(solrFulltextAllFieldName, fieldValue);
                Object oneFieldValue = SolrUtil.getOneValue(fieldValue);
                doc.setField(solrAllFieldName + "_sortable", oneFieldValue);
                doc.setField(solrFulltextAllFieldName + "_sortable", oneFieldValue);
                doc.setField(solrFqFieldNameSortable, oneFieldValue);
            }
        }
    }

    public int rollback() {
        this.clear();
        return 7;
    }

    public void pack(OutputObjectState arg0) throws IOException {
    }

    public void unpack(InputObjectState arg0) throws IOException {
    }
}

