/*
 * #%L
 * Wikitty :: wikitty-solr-impl
 * 
 * $Id: TypeFieldModifier.java 650 2010-12-23 11:44:57Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.4/wikitty-solr-impl/src/main/java/org/nuiton/wikitty/storage/solr/TypeFieldModifier.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.storage.solr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;

import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SOLR_ALL_EXTENSIONS;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SOLR_EXTENSIONS;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SOLR_ID;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_BINARY;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_BOOLEAN;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_DATE;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_NUMERIC;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_STRING;
import static org.nuiton.wikitty.storage.solr.WikittySolrConstant.SUFFIX_WIKITTY;

/**
 *
 * @author poussin
 * @version $Revision: 650 $
 *
 * Last update: $Date: 2010-12-23 12:44:57 +0100 (jeu., 23 déc. 2010) $
 * by : $Author: sletellier $
 */
public class TypeFieldModifier implements FieldModifier {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(TypeFieldModifier.class);

    protected WikittyExtensionStorage extensionStorage;

    public TypeFieldModifier(WikittyExtensionStorage extensionStorage) {
        this.extensionStorage = extensionStorage;
    }

    @Override
    public String convertToSolr(WikittyTransaction transaction, String fqfieldname) {
        String result = fqfieldname;
        String[] searchField = fqfieldname.split(WikittyUtil.FQ_FIELD_NAME_SEPARATOR_REGEX);

        if (Element.ELT_EXTENSION.equals(fqfieldname)) {
            result = SOLR_EXTENSIONS;

        } else if (Element.ELT_ID.equals(fqfieldname)) {
            result = SOLR_ID;

        } else if (searchField.length >= 2) {
            String extName = searchField[0];
            String fieldName = searchField[1];

            if (Criteria.ALL_EXTENSIONS.equals(extName)) {
                fqfieldname = SOLR_ALL_EXTENSIONS
                        + WikittyUtil.FQ_FIELD_NAME_SEPARATOR + fieldName;
            }

            if (searchField.length >= 3) {
                // TODO poussin 20101209 je ne vois pas dans quel cas on passe ici
                String fieldNameType = searchField[2];
                TYPE type = FieldType.TYPE.valueOf(fieldNameType);
                result = SolrUtil.getSolrFieldName(fqfieldname, type);
                return result;
            }

            // Search type of field in extension
            String version =
                    extensionStorage.getLastVersion(transaction, extName);
            if (version != null) { // not valid extension if version == null
                WikittyExtension ext = extensionStorage.restore(
                        transaction, extName, version);
                FieldType fieldType = ext.getFieldType(fieldName);
                if (log.isDebugEnabled()) {
                    log.debug(ext.toDefinition() + " for " + fieldName);
                }
                if (fieldType != null) { // type can be null if extension version differ
                    TYPE type = fieldType.getType();
                    result = SolrUtil.getSolrFieldName(fqfieldname, type);
                    return result;
                }
            }
        }

        return result;
    }

    /**
     * if you change this, change
     * {@link WikittySearchEngineSolr#getSolrFieldName(java.lang.String, org.nuiton.wikitty.entities.FieldType.TYPE)}
     * too
     */
    @Override
    public String convertToField(WikittyTransaction transaction, String solrName) {
        String fieldName = solrName.replaceAll(
                "(" + SUFFIX_BINARY + "$)"
                + "|(" + SUFFIX_BOOLEAN + "$)"
                + "|(" + SUFFIX_DATE + "$)"
                + "|(" + SUFFIX_STRING + "$)"
                + "|(" + SUFFIX_WIKITTY + "$)"
                + "|(" + SUFFIX_NUMERIC + "$)", "");
        if (SOLR_EXTENSIONS.equals(fieldName)) {
            fieldName = Element.ELT_EXTENSION;
        }
        return fieldName;
    }
}
