/*
 * #%L
 * Wikitty :: wikitty-solr-impl
 * 
 * $Id: SolrResource.java 699 2011-01-31 12:13:07Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.4/wikitty-solr-impl/src/main/java/org/nuiton/wikitty/storage/solr/SolrResource.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.storage.solr;


import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.LastResourceRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.common.SolrInputDocument;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Use to plug solr indexation in JTA transaction.
 *
 * @author poussin
 * @version $Revision: 699 $
 *
 * Last update: $Date: 2011-01-31 13:13:07 +0100 (lun., 31 janv. 2011) $
 * by : $Author: bpoussin $
 */
public class SolrResource implements OnePhaseResource {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(SolrResource.class);

    protected SolrServer solrServer;
    // FIXME poussin 20110131 est-ce vraiment util d'utiliser des ThreadLocal  ?
    // WikittyTransaction est deja un ThreadLocal
    protected ThreadLocal<Map<String, SolrInputDocument>> addedDocs;
    protected ThreadLocal<List<String>> deletedDocs;

    public SolrResource(SolrServer solrServer) {
        this.solrServer = solrServer;
        addedDocs = new ThreadLocal<Map<String, SolrInputDocument>>();
        deletedDocs = new ThreadLocal<List<String>>();

        clear();
    }

    protected void init() {
        // Add resource on phase in current transaction
        LastResourceRecord lastResourceRecord = new LastResourceRecord(this);
        BasicAction.Current().add(lastResourceRecord);
    }

    public Map<String, SolrInputDocument> getAddedDocs() {
        Map<String, SolrInputDocument> result = addedDocs.get();
        if (result == null) {
            result = new HashMap<String, SolrInputDocument>();
            addedDocs.set(result);
        }
        return result;
    }

    public List<String> getDeletedDocs() {
        List<String> result = deletedDocs.get();
        if (result == null) {
            result = new ArrayList<String>();
            deletedDocs.set(result);
        }
        return result;
    }

    public void clear() {
        addedDocs.set(new HashMap<String, SolrInputDocument>());
        deletedDocs.set(new ArrayList<String>());
    }

    public void addDoc(String id, SolrInputDocument doc) {
        getAddedDocs().put(id, doc);
    }

    public SolrInputDocument getAddedDoc(String id) {
        SolrInputDocument result = getAddedDocs().get(id);
        return result;
    }

    public Collection<String> getAddedDocIds() {
        Collection<String> result = getAddedDocs().keySet();
        return result;
    }

    public void deleteDoc(String docId) {
        getDeletedDocs().add(docId);
    }

    @Override
    public int commit() {
        try {
            synchronized (this) {
                Collection<SolrInputDocument> docs = getAddedDocs().values();
                if (!docs.isEmpty()) {
                    solrServer.add(docs);
                }
                List<String> ids = getDeletedDocs();
                if (!ids.isEmpty()) {
                    solrServer.deleteById(ids);
                }
                solrServer.commit();
            }
            clear();
            return TwoPhaseOutcome.FINISH_OK;
        } catch (Exception eee) {
            log.error("Error commit solr", eee);
            return TwoPhaseOutcome.FINISH_ERROR;
        }
    }

    @Override
    public int rollback() {
        clear();
        return TwoPhaseOutcome.FINISH_OK;
    }

    @Override
    public void pack(OutputObjectState arg0) throws IOException {
    }

    @Override
    public void unpack(InputObjectState arg0) throws IOException {
    }
}
