<!--
  #%L
  Wikitty :: publication
  
  $Id: edit.jsp 650 2010-12-23 11:44:57Z sletellier $
  $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.4/wikitty-publication/src/main/webapp/WEB-INF/jsp/edit.jsp $
  %%
  Copyright (C) 2010 CodeLutin, Benjamin Poussin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as 
  published by the Free Software Foundation, either version 3 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Lesser Public License for more details.
  
  You should have received a copy of the GNU General Lesser Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/lgpl-3.0.html>.
  #L%
  -->
<%-- 
    Document   : edit
    Created on : 6 d�c. 2010, 18:32:18
    Author     : poussin
--%>

<%@page import="org.nuiton.wikitty.publication.ActionEval"%>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>
<%@page import="org.nuiton.wikitty.entities.FieldType"%>
<%@page import="java.util.Collection"%>
<%@page import="org.nuiton.wikitty.WikittyProxy"%>
<%@page import="org.nuiton.wikitty.WikittyService"%>
<%@page import="org.nuiton.wikitty.entities.WikittyExtension"%>
<%@page import="org.nuiton.wikitty.publication.ActionEdit"%>
<%@page import="org.nuiton.wikitty.entities.Wikitty"%>
<%@page import="org.nuiton.wikitty.publication.WikittyPublicationContext"%>

<%
WikittyPublicationContext context = (WikittyPublicationContext)
        request.getAttribute(ActionEval.CONTEXT_VAR);
Wikitty wikitty = (Wikitty)request.getAttribute(ActionEval.WIKITTY_VAR);
ActionEdit action = context.getAction(ActionEdit.class);
String url = action.makeUrl(context, wikitty);
%>

<h1>Edit <%=wikitty.getId()%></h1>

<pre><%=StringEscapeUtils.escapeHtml(String.valueOf(wikitty))%></pre>

<form class="edit" action='<%=url%>' method="post" enctype="multipart/form-data">
    <input type="hidden" name="MAX_FILE_SIZE" value="104857600" /> <!-- 100Mo -->
    <input type="hidden" name="id" value="<%=wikitty.getId()%>" />
    <input type="hidden" name="version" value="<%=wikitty.getVersion()%>" />
    <input type="hidden" name="extensions" value="<%=wikitty.getExtensionNames()%>"/>
   <fieldset>
       <legend><span class="legend">Extensions</span></legend>
       Current extension: <%=wikitty.getExtensionNames()%>
    <%
   WikittyProxy proxy = context.getWikittyProxy();
   Collection<String> allExt = proxy.getAllExtensionIds();
   if (allExt != null && allExt.size() > 0) {
  %>
        <select name="newExtension" size="1">
  <option value="" selected="true"></option>
  <%
       for (String extId : allExt) {
           String extName = WikittyExtension.computeName(extId);
           if (!wikitty.hasExtension(extName)) {
  %>
  <option value="<%=extName%>"><%=extName%></option>
  <%
           }
       }
  %>
        </select>
  <%
  }
   %>
     <input type="submit" name="addExtension" value="Add" />
   </fieldset>

   <%
   int index = 0;
   for (WikittyExtension ext : wikitty.getExtensions()) {
       String extName = ext.getName();
   %>
   <fieldset>
       <legend><span class="legend"><%=extName%></span></legend>
       <%
       for (String fieldName : ext.getFieldNames()) {
           FieldType fieldType = wikitty.getExtension(extName).getFieldType(fieldName);
  %>
    <div>
        <label for="<%=extName%>.<%=fieldName%>" tabindex="<%=++index%>"><span class="label"><%=fieldName%></span></label>
  <%
           switch(fieldType.getType()) {
               case BINARY:
  %>
        <input type="file" name="<%=extName%>.<%=fieldName%>"/>
  <%
                   break;
               case BOOLEAN:
                   boolean valueBool = wikitty.getFieldAsBoolean(ext.getName(), fieldName);
                   String checked = valueBool?"checked='true'":"";
  %>
        <input type="checkbox" name="<%=extName%>.<%=fieldName%>" value="true" <%=checked%>/>
  <%
                   break;
               default:
                   Object valueObject = wikitty.getFieldAsObject(ext.getName(), fieldName);
                   String valueString = "";
                   String checkedNull = "";
                   if (valueObject != null) {
                       valueString = String.valueOf(valueObject);
                   } else {
                       checkedNull = "checked='true'";
                   }

                   valueString = StringEscapeUtils.escapeHtml(valueString);
                   if (valueString.contains("\n") || "true".equals(fieldType.getTagValue("multiline"))) {
  %>
        <textarea cols="80" rows="20" name="<%=extName%>.<%=fieldName%>"><%=valueString%></textarea>
  <%
                   } else {
  %>
        <input type="text" name="<%=extName%>.<%=fieldName%>" value="<%=valueString%>" />
  <%
                   }
  %>
        <input type="checkbox" name="isNull-<%=extName%>.<%=fieldName%>" value="true" <%=checkedNull%>/>(null)
  <%
           }
  %>
        <%=fieldType.toDefinition("")%>
    </div>
  <%
       }
  %>
  </fieldset>
  <%
   }
  %>
  <input type="submit" name="store" value="Store" />
  <input type="submit" name="delete" value="Delete" />
</form>
