/*
 * #%L
 * Wikitty :: dto
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;


public  class WikittyTreeNodeDTO implements WikittyTreeNode {


@WikittyField(fqn="WikittyTreeNode.name")    protected String name;

@WikittyField(fqn="WikittyTreeNode.attachment")    protected Set<String> attachment = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyTreeNode.parent")    protected String parent;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        return name;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAttachment() {
        return attachment;
}

    /**
     * setAttachment :
     * @param attachment 
     */

    @Override
    public void setAttachment(Set<String> attachment) {
        if (attachment == null){
            this.attachment = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.attachment=new LinkedHashSet<String>(attachment);
        }
        modificationCount++;
}

    /**
     * addAllAttachment :
     * @param attachment 
     */

    @Override
    public void addAllAttachment(Set<String> attachment) {
        if (this.attachment == null){
            this.attachment = new LinkedHashSet<String>();
        }
        this.attachment.addAll(attachment);
        modificationCount++;
}

    /**
     * addAttachment :
     * @param element 
     */

    @Override
    public void addAttachment(String element) {
        if (this.attachment == null){
            this.attachment = new LinkedHashSet<String>();
        }
        this.attachment.add(element);
        modificationCount++;
}

    /**
     * removeAttachment :
     * @param element 
     */

    @Override
    public void removeAttachment(String element) {
        attachment.remove(element);
        modificationCount++;
}

    /**
     * clearAttachment :
     */

    @Override
    public void clearAttachment() {
        attachment.clear();
        modificationCount++;
}

    /**
     * getParent :
     * @return String 
     */

    @Override
    public String getParent() {
        return parent;
}

    /**
     * setParent :
     * @param parent 
     */

    @Override
    public void setParent(String parent) {
        this.parent=parent;
        modificationCount++;
}

    /**
     * WikittyTreeNodeDTO :
     */

    public WikittyTreeNodeDTO() {
}

    /**
     * WikittyTreeNodeDTO :
     * @param wikittyId 
     */

    public WikittyTreeNodeDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyTreeNode)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyTreeNode sourceCopy = (WikittyTreeNode)source;

        setName(sourceCopy.getName());

        Set<String> attachment = sourceCopy.getAttachment();
        if (attachment != null){
            setAttachment(new LinkedHashSet<String>(attachment));
        }

        setParent(sourceCopy.getParent());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //WikittyTreeNodeDTO
