package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class RealmHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private RealmHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Realm.EXT_REALM, Realm.FIELD_REALM_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Realm.EXT_REALM, Realm.FIELD_REALM_NAME, name);
        return oldValue;
}

    public static String getTree(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Realm.EXT_REALM, Realm.FIELD_REALM_TREE);
        return value;
}

    public static String setTree(Wikitty wikitty, String tree) {
        String oldValue = getTree(wikitty);
        wikitty.setField(Realm.EXT_REALM, Realm.FIELD_REALM_TREE, tree);
        return oldValue;
}

    public static String getKing(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Realm.EXT_REALM, Realm.FIELD_REALM_KING);
        return value;
}

    public static String setKing(Wikitty wikitty, String king) {
        String oldValue = getKing(wikitty);
        wikitty.setField(Realm.EXT_REALM, Realm.FIELD_REALM_KING, king);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_NAME);
            Object f2 = w2.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_TREE);
            Object f2 = w2.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_TREE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_KING);
            Object f2 = w2.getFieldAsObject(Realm.EXT_REALM, Realm.FIELD_REALM_KING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Realm.EXT_REALM);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : RealmAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Realm.EXT_REALM);
}

} //RealmHelper
