package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class BirdAbstract extends BusinessEntityImpl implements Bird {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionBird;

    @Override
    public int getFly() {
int value = BirdHelper.getFly(getWikitty());
return value;
}

    @Override
    public void setFly(int fly) {
int oldValue = getFly();
BirdHelper.setFly(getWikitty(), fly);
getPropertyChangeSupport().firePropertyChange(Bird.FIELD_BIRD_FLY, oldValue, getFly());
}

    @Override
    public String getColor() {
String value = BirdHelper.getColor(getWikitty());
return value;
}

    @Override
    public void setColor(String color) {
String oldValue = getColor();
BirdHelper.setColor(getWikitty(), color);
getPropertyChangeSupport().firePropertyChange(Bird.FIELD_BIRD_COLOR, oldValue, getColor());
}

    public BirdAbstract() {
        super();
}

    public BirdAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public BirdAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionBird = new WikittyExtension(EXT_BIRD,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                Animal.EXT_ANIMAL + "," + Mineral.EXT_MINERAL + "," + Vegetal.EXT_VEGETAL,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Numeric fly unique=\"true\"", 
                                             "String color unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(AnimalAbstract.extensions); 
        // current after requires ones

        exts.addAll(MineralAbstract.extensions); 
        // current after requires ones

        exts.addAll(VegetalAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBird);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return BirdHelper.toString(getWikitty());
}

} //BirdAbstract
