package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Thu Aug 06 22:58:12 CEST 2015")
public class WikittyLabelHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyLabelHelper() {// empty
}

    public static Set<String> getLabels(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, String.class);
        return result;
}

    public static void setLabels(Wikitty wikitty, Set<String> labels) {
        wikitty.setField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, labels);
}

    public static void addAllLabels(Wikitty wikitty, Collection<String> labels) {
        if(labels != null){
            for (String v:labels){
                addLabels(wikitty, v);
            }
        }
}

    public static void addLabels(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, v);
        }
}

    public static void removeLabels(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, v);
        }
}

    public static void clearLabels(Wikitty wikitty) {
        wikitty.clearField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
            Object f2 = w2.getFieldAsObject(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyLabel.EXT_WIKITTYLABEL);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyLabelAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyLabelAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyLabel.EXT_WIKITTYLABEL);
}

} //WikittyLabelHelper
