/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;

public class WikittyExtensionStorageInMemory
implements WikittyExtensionStorage {
    protected Map<String, WikittyExtension> extensions = new HashMap<String, WikittyExtension>();

    public Map<String, WikittyExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, WikittyExtension> extensions) {
        this.extensions = extensions;
    }

    @Override
    public WikittyEvent store(WikittyTransaction transaction, Collection<WikittyExtension> exts) throws WikittyException {
        WikittyEvent result = new WikittyEvent(this);
        for (WikittyExtension ext : exts) {
            if (this.extensions.containsKey(ext.getId())) continue;
            this.extensions.put(ext.getId(), ext);
            result.addExtension(ext);
        }
        return result;
    }

    @Override
    public WikittyEvent delete(WikittyTransaction transaction, Collection<String> extNames) {
        WikittyEvent result = new WikittyEvent(this);
        HashSet<String> extToDelete = new HashSet<String>(extNames);
        Iterator<Map.Entry<String, WikittyExtension>> i = this.extensions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, WikittyExtension> entry = i.next();
            String name = WikittyExtension.computeName(entry.getKey());
            if (!extToDelete.contains(name)) continue;
            i.remove();
            result.addDeletedExtension(name);
        }
        return result;
    }

    @Override
    public boolean exists(WikittyTransaction transaction, String id) {
        boolean result = this.extensions.containsKey(id);
        return result;
    }

    @Override
    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        ArrayList<String> result = new ArrayList<String>(this.extensions.keySet());
        return result;
    }

    @Override
    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        ArrayList<String> ids = new ArrayList<String>();
        Collection<WikittyExtension> values = this.extensions.values();
        if (values != null) {
            for (WikittyExtension extension : values) {
                if (!extension.getRequires().contains(extensionName)) continue;
                ids.add(extension.getId());
            }
        }
        return ids;
    }

    @Override
    public String getLastVersion(WikittyTransaction transaction, String extName) {
        String result = null;
        Set<String> extensionIds = this.extensions.keySet();
        for (String extensionId : extensionIds) {
            String extensionVersion = WikittyExtension.computeVersion(extensionId);
            if (!extensionId.startsWith(extName) || result != null && !WikittyUtil.versionGreaterThan(extensionVersion, result)) continue;
            result = extensionVersion;
        }
        return result;
    }

    @Override
    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        String id = WikittyExtension.computeId(name, version);
        WikittyExtension result = this.extensions.get(id);
        if (result == null) {
            throw new WikittyException(String.format("No extension with id '%s'", id));
        }
        return result;
    }

    @Override
    public WikittyEvent clear(WikittyTransaction transaction) {
        this.extensions = new HashMap<String, WikittyExtension>();
        WikittyEvent result = new WikittyEvent(this);
        result.addType(WikittyEvent.WikittyEventType.CLEAR_EXTENSION);
        return result;
    }
}

