/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.FacetQuery;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.query.function.FunctionValue;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;

public class WikittyQueryVisitorCopy
extends WikittyQueryVisitor {
    private static Log log = LogFactory.getLog(WikittyQueryVisitorCopy.class);
    protected WikittyQueryMaker queryMaker;
    protected List<WikittyQueryFunction> functions = new ArrayList<WikittyQueryFunction>();

    protected List<WikittyQueryFunction> getAndClearFunction(int size) {
        int last = this.functions.size();
        List<WikittyQueryFunction> tmp = this.functions.subList(last - size, last);
        ArrayList<WikittyQueryFunction> result = new ArrayList<WikittyQueryFunction>(tmp);
        tmp.clear();
        return result;
    }

    protected void addFunction(WikittyQueryFunction f) {
        this.functions.add(f);
    }

    protected WikittyQueryMaker getQueryMaker() {
        if (this.queryMaker == null) {
            this.queryMaker = new WikittyQueryMaker();
        }
        return this.queryMaker;
    }

    public WikittyQuery getQuery() {
        WikittyQuery result = this.getQueryMaker().getQuery();
        return result;
    }

    public Condition getCondition() {
        Condition result = this.getQueryMaker().getCondition();
        return result;
    }

    @Override
    public boolean visitEnter(WikittyQuery o) {
        WikittyQuery q = this.getQuery();
        q.setFacetExtension(q.isFacetExtension());
        q.setFacetField(new ArrayList<Element>(o.getFacetField()));
        q.setFacetLimit(o.getFacetLimit());
        q.setFacetMinCount(o.getFacetMinCount());
        q.setOffset(o.getOffset());
        q.setLimit(o.getLimit());
        q.setFacetSort(o.getFacetSort());
        q.setName(o.getName());
        q.setSortAscending(new ArrayList<Element>(o.getSortAscending()));
        q.setSortDescending(new ArrayList<Element>(o.getSortDescending()));
        q.setWikittyFieldSearchDepth(o.getWikittyFieldSearchDepth());
        for (FacetQuery c : o.getFacetQuery()) {
            WikittyQueryVisitorCopy v = new WikittyQueryVisitorCopy();
            c.getCondition().accept(v);
            Condition condition = v.getCondition();
            q.addFacetQuery(c.getName(), condition);
        }
        return true;
    }

    @Override
    public void visitLeave(WikittyQuery o, boolean enterResult) {
    }

    @Override
    public void visit(ConditionValueString o) {
        this.getQueryMaker().value(o);
    }

    @Override
    public boolean visitEnter(And o) {
        this.getQueryMaker().and();
        return true;
    }

    @Override
    public boolean visitMiddle(And o) {
        return true;
    }

    @Override
    public void visitLeave(And o, boolean enterResult) {
        this.getQueryMaker().close();
    }

    @Override
    public boolean visitEnter(Or o) {
        this.getQueryMaker().or();
        return true;
    }

    @Override
    public boolean visitMiddle(Or o) {
        return true;
    }

    @Override
    public void visitLeave(Or o, boolean enterResult) {
        this.getQueryMaker().close();
    }

    @Override
    public boolean visitEnter(Select o) {
        return true;
    }

    @Override
    public boolean visitMiddle(Select o) {
        WikittyQueryFunction f = null;
        if (o.getFunction() != null) {
            List<WikittyQueryFunction> fs = this.getAndClearFunction(1);
            if (!this.functions.isEmpty()) {
                throw new IllegalStateException("function list must be empty here");
            }
            f = fs.get(0);
        }
        this.getQueryMaker().select(f);
        this.getQueryMaker().where();
        return true;
    }

    @Override
    public void visitLeave(Select o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Not o) {
        this.getQueryMaker().not();
        return true;
    }

    @Override
    public void visitLeave(Not o, boolean enterResult) {
    }

    @Override
    public boolean visitEnter(Between o) {
        this.getQueryMaker().bw(o.getElement());
        return true;
    }

    @Override
    public boolean visitMiddle(Between o) {
        return true;
    }

    @Override
    public void visitLeave(Between o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(ContainsAll o) {
        this.getQueryMaker().containsAll(o.getElement());
        return true;
    }

    @Override
    public boolean visitMiddle(ContainsAll o) {
        return true;
    }

    @Override
    public void visitLeave(ContainsAll o, boolean enterOrMiddleResult) {
        this.getQueryMaker().close();
    }

    @Override
    public boolean visitEnter(ContainsOne o) {
        this.getQueryMaker().containsOne(o.getElement());
        return true;
    }

    @Override
    public boolean visitMiddle(ContainsOne o) {
        return true;
    }

    @Override
    public void visitLeave(ContainsOne o, boolean enterOrMiddleResult) {
        this.getQueryMaker().close();
    }

    @Override
    public boolean visitEnter(Equals o) {
        if (o.isIgnoreCaseAndAccent()) {
            this.getQueryMaker().eqIgnoreCaseAndAccent(o.getElement());
        } else {
            this.getQueryMaker().eq(o.getElement());
        }
        return true;
    }

    @Override
    public void visitLeave(Equals o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(NotEquals o) {
        if (o.isIgnoreCaseAndAccent()) {
            this.getQueryMaker().neIgnoreCaseAndAccent(o.getElement());
        } else {
            this.getQueryMaker().ne(o.getElement());
        }
        return true;
    }

    @Override
    public void visitLeave(NotEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public void visit(False o) {
        this.getQueryMaker().rFalse();
    }

    @Override
    public void visit(True o) {
        this.getQueryMaker().rTrue();
    }

    @Override
    public boolean visitEnter(Greater o) {
        this.getQueryMaker().gt(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(Greater o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(GreaterOrEquals o) {
        this.getQueryMaker().ge(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(GreaterOrEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Keyword o) {
        this.getQueryMaker().keyword();
        return true;
    }

    @Override
    public void visitLeave(Keyword o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Less o) {
        this.getQueryMaker().lt(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(Less o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(LessOrEquals o) {
        this.getQueryMaker().le(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(LessOrEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Like o) {
        this.getQueryMaker().like(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(Like o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Unlike o) {
        this.getQueryMaker().unlike(o.getElement());
        return true;
    }

    @Override
    public void visitLeave(Unlike o, boolean enterOrMiddleResult) {
    }

    @Override
    public void visit(Null o) {
        this.getQueryMaker().isNull(o.getElement());
    }

    @Override
    public void visit(NotNull o) {
        this.getQueryMaker().isNotNull(o.getElement());
    }

    @Override
    public boolean visitEnter(WikittyQueryFunction function) {
        return true;
    }

    @Override
    public boolean visitMiddle(WikittyQueryFunction function) {
        return true;
    }

    @Override
    public void visitLeave(WikittyQueryFunction function, boolean enterOrMiddleResult) {
        List<WikittyQueryFunction> args = this.getAndClearFunction(function.getArgs().size());
        WikittyQueryFunction f = WikittyQueryFunction.create(function.getMethodName(), function.getName(), args);
        this.addFunction(f);
    }

    @Override
    public void visit(FunctionValue function) {
        this.addFunction(new FunctionValue(function.getName(), function.getValue()));
    }

    @Override
    public void defaultVisit(Object o) {
        throw new UnsupportedOperationException("Not supported (" + o.getClass().getSimpleName() + ").");
    }

    @Override
    public boolean defaultVisitEnter(Object o) {
        throw new UnsupportedOperationException("Not supported (" + o.getClass().getSimpleName() + ").");
    }

    @Override
    public boolean defaultVisitMiddle(Object o) {
        throw new UnsupportedOperationException("Not supported (" + o.getClass().getSimpleName() + ").");
    }

    @Override
    public void defaultVisitLeave(Object o, boolean enterResult) {
        throw new UnsupportedOperationException("Not supported (" + o.getClass().getSimpleName() + ").");
    }
}

