package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class ProductPictureAbstract extends BusinessEntityImpl implements ProductPicture {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionProductPicture;

    private static final long serialVersionUID = 3834308415651527009L;

    @Override
    public String getPicture() {
String value = ProductPictureHelper.getPicture(getWikitty());
return value;
}

    @Override
    public void setPicture(String picture) {
String oldValue = getPicture();
ProductPictureHelper.setPicture(getWikitty(), picture);
getPropertyChangeSupport().firePropertyChange(ProductPicture.FIELD_PRODUCTPICTURE_PICTURE, oldValue, getPicture());
}

    @Override
    public int getPicturePrice() {
int value = ProductPictureHelper.getPicturePrice(getWikitty());
return value;
}

    @Override
    public void setPicturePrice(int price) {
int oldValue = getPicturePrice();
ProductPictureHelper.setPicturePrice(getWikitty(), price);
getPropertyChangeSupport().firePropertyChange(ProductPicture.FIELD_PRODUCTPICTURE_PRICE, oldValue, getPicturePrice());
}

    public ProductPictureAbstract() {
        super();
}

    public ProductPictureAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public ProductPictureAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionProductPicture = new WikittyExtension(EXT_PRODUCTPICTURE,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String picture fieldIndex=\"1\"", 
                                             "Numeric price fieldIndex=\"2\" alternativeName=\"picturePrice\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionProductPicture);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return ProductPictureHelper.toString(getWikitty());
}

} //ProductPictureAbstract
