/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyServiceCachedTest.java 805 2011-04-13 16:59:23Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.2/wikitty-api/src/test/java/org/nuiton/wikitty/services/WikittyServiceCachedTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.services;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserImpl;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.WikittyConfigOption;

/**
 *
 * @author poussin
 * @version $Revision: 805 $
 *
 * Last update: $Date: 2011-04-13 18:59:23 +0200 (mer., 13 avril 2011) $
 * by : $Author: bpoussin $
 */
public class WikittyServiceCachedTest {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceCachedTest.class);

    protected ApplicationConfig getConfig() {
        ApplicationConfig result = WikittyConfig.getConfig();
        return result;
    }

    @Test
    public void testCache() throws Exception {
        ApplicationConfig config = getConfig();
        config.setOption(WikittyConfigOption
                .JCS_DEFAULT_CACHEATTRIBUTES_MAXOBJECTS.getKey(), "10");
        WikittyServiceInMemory ws = new WikittyServiceInMemory(config);
        WikittyCache cache = new WikittyCacheJCS(config);
        WikittyServiceCached wscached = new WikittyServiceCached(config, ws, cache);
   
        WikittyProxy proxy = new WikittyProxy(config, wscached);
        List<BusinessEntity> toStore = new ArrayList<BusinessEntity>();
        List<String> toRestore = new ArrayList<String>();

        WikittyUser u1 = new WikittyUserImpl();
        WikittyUser u2 = new WikittyUserImpl();
        WikittyUser u3 = new WikittyUserImpl();
        WikittyUser u4 = new WikittyUserImpl();
        WikittyUser u5 = new WikittyUserImpl();

        toStore.add(u1);
        toStore.add(u2);
        toStore.add(u3);
        toStore.add(u4);
        toStore.add(u5);

        toStore = proxy.store(toStore);

        u1 = proxy.restore(WikittyUser.class, u1.getWikittyId());
        u2 = proxy.restore(WikittyUser.class, u2.getWikittyId());
        u3 = proxy.restore(WikittyUser.class, u3.getWikittyId());
        u4 = proxy.restore(WikittyUser.class, u4.getWikittyId());
        u5 = proxy.restore(WikittyUser.class, u5.getWikittyId());
        u1 = proxy.restore(WikittyUser.class, u1.getWikittyId());
        u2 = proxy.restore(WikittyUser.class, u2.getWikittyId());
        u3 = proxy.restore(WikittyUser.class, u3.getWikittyId());

        toRestore.add(u1.getWikittyId());
        toRestore.add(u2.getWikittyId());
        toRestore.add(u3.getWikittyId());
        toRestore.add(u4.getWikittyId());
        toRestore.add(u5.getWikittyId());

        proxy.restore(WikittyUser.class, toRestore);
    }
}
