/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyI18nTest.java 805 2011-04-13 16:59:23Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.2/wikitty-api/src/test/java/org/nuiton/wikitty/addons/WikittyI18nTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.addons;


import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.addons.WikittyI18nImpl;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.WikittyI18n;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelImpl;

/**
 *
 * @author poussin
 * @version $Revision: 805 $
 *
 * Last update: $Date: 2011-04-13 18:59:23 +0200 (mer., 13 avril 2011) $
 * by : $Author: bpoussin $
 */
public class WikittyI18nTest {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyI18nTest.class);

    @Test
    public void testI18n() throws Exception {
        // creation d'un proxy sur un ws in memory
        ApplicationConfig config = WikittyConfig.getConfig();
        WikittyService ws = new WikittyServiceInMemory(config);
        WikittyProxy proxy = new WikittyProxy(ws);

        // creation d'un label pour l'utiliser pour l'i18n
        WikittyLabel label = new WikittyLabelImpl();
        Wikitty labelWikitty = WikittyUtil.getWikitty(ws,null,label);
        WikittyExtension ext =
                labelWikitty.getExtension(WikittyLabel.EXT_WIKITTYLABEL);

        // recuperation de support i18n pour l'extension WikittyLabel
        WikittyI18n i18n = WikittyI18nUtil.getI18n(proxy, ext);

        // ajout d'une traduction pour le francais
        i18n.setTranslation("fr", WikittyLabel.FIELD_WIKITTYLABEL_LABELS, "étiquette");
        proxy.store(i18n);

        String trad = i18n.getTranslation("fr", WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
        Assert.assertEquals("étiquette", trad);
        Assert.assertEquals(1, i18n.getLang().size());
        Assert.assertEquals("fr", i18n.getLang().iterator().next());
        Assert.assertEquals("[fr:\"labels\"=\"étiquette\"]", i18n.getTranslations());

        // ajout d'une traduction pour l'espagnole
        i18n.setTranslation("es", WikittyLabel.FIELD_WIKITTYLABEL_LABELS, "etiqueta");

        Assert.assertEquals(2, i18n.getLang().size());

        // on force le vidage du cache pour voir si le parsing se passe bien
        ((WikittyI18nImpl)i18n).translationsCache = null;
        trad = i18n.getTranslation("fr", WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
        Assert.assertEquals("étiquette", trad);

//        System.out.println(i18n.getTranslations());
    }

}
