package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class WikittyUserAbstract extends BusinessEntityWikitty implements WikittyUser {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyUser;
    /**
     * getLogin :
     * @return String 
     */

    @Override
    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    @Override
    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * WikittyUserAbstract :
     */

    public WikittyUserAbstract() {
        super();
}

    /**
     * WikittyUserAbstract :
     * @param wikitty 
     */

    public WikittyUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyUserAbstract :
     * @param businessEntityWikitty 
     */

    public WikittyUserAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyUser =
                new WikittyExtension(EXT_WIKITTYUSER,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String login unique=true", 
                                             "String password unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyUserAbstract
