package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class SecurityTokenHelper {

    /**
     * SecurityTokenHelper :
     * utility class all provided methods are accessible the static way
     */

    private SecurityTokenHelper() {// empty
}

    /**
     * getUser :
     * @param wikitty 
     * @return String 
     */

    public static String getUser(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(SecurityToken.EXT_SECURITYTOKEN, SecurityToken.FIELD_SECURITYTOKEN_USER);
        return value;
}

    /**
     * setUser :
     * @param wikitty 
     * @param user 
     * @return String 
     */

    public static String setUser(Wikitty wikitty, String user) {
        String oldValue = getUser(wikitty);
        wikitty.setField(SecurityToken.EXT_SECURITYTOKEN, SecurityToken.FIELD_SECURITYTOKEN_USER, user);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(SecurityToken.EXT_SECURITYTOKEN, SecurityToken.FIELD_SECURITYTOKEN_USER);
            Object f2 = w2.getFieldAsObject(SecurityToken.EXT_SECURITYTOKEN, SecurityToken.FIELD_SECURITYTOKEN_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(SecurityToken.EXT_SECURITYTOKEN);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : SecurityTokenAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //SecurityTokenHelper
