/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.nuiton.topia.replication.model.ReplicationNode;

public class Link {
    protected final ReplicationNode source;
    protected final Set<ReplicationNode> requires;
    protected final ReplicationNode target;
    protected final String name;
    protected final boolean association;

    public Link(ReplicationNode source, ReplicationNode target, String name, boolean association) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.association = association;
        HashSet<ReplicationNode> tmpSet = new HashSet<ReplicationNode>();
        tmpSet.add(source);
        tmpSet.addAll(source.getAssociations().values());
        tmpSet.addAll(source.getDependencies().values());
        tmpSet.remove(target);
        this.requires = Collections.unmodifiableSet(tmpSet);
    }

    public String getName() {
        return this.name;
    }

    public ReplicationNode getSource() {
        return this.source;
    }

    public ReplicationNode getTarget() {
        return this.target;
    }

    public boolean isAssociation() {
        return this.association;
    }

    public boolean canReattach(Set<ReplicationNode> universe, ReplicationNode currentNode) {
        boolean result = universe.containsAll(this.requires);
        if (result) {
            result = currentNode.equals(this.target) || universe.contains(this.target);
        }
        return result;
    }

    public String toString() {
        return "<source:" + this.source + ", target:" + this.target + ", name:" + this.name + ", association:" + this.association + ">";
    }
}

