/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.topia.persistence.HqlAndParametersBuilder;
import org.nuiton.topia.persistence.TopiaEntity;

public class HqlAndParametersBuilderTest {
    protected HqlAndParametersBuilder hqlAndParametersBuilder = new HqlAndParametersBuilder(TopiaEntity.class);
    protected static final Collection<String> SOME_VALUES = Lists.newArrayList((Object[])new String[]{"value1", "value2", "value3"});
    protected static final Collection<String> SOME_VALUES_WITH_NULL = Lists.newArrayList((Object[])new String[]{"value1", "value2", null, "value3"});

    @Test
    public void testFindAvailableHqlParameterName() {
        String availableHqlParameterName1 = this.hqlAndParametersBuilder.putHqlParameterWithAvailableName("survey.topiaId", (Object)"topiaId1");
        String availableHqlParameterName2 = this.hqlAndParametersBuilder.putHqlParameterWithAvailableName("survey.topiaId", (Object)"topiaId1");
        Assert.assertNotEquals((Object)availableHqlParameterName1, (Object)availableHqlParameterName2);
        Assert.assertFalse((boolean)availableHqlParameterName1.contains("."));
        Assert.assertFalse((boolean)availableHqlParameterName2.contains("."));
    }

    @Test
    public void testEqualsNull() {
        this.hqlAndParametersBuilder.addEquals("myProp", null);
        String actualHql = this.hqlAndParametersBuilder.getHql();
        Assert.assertFalse((boolean)actualHql.contains("myProp = null"));
        Assert.assertTrue((boolean)actualHql.contains("myProp is null"));
    }

    @Test
    public void testAddInWithNull() {
        this.hqlAndParametersBuilder.addIn("myProp", SOME_VALUES_WITH_NULL);
        String actualHql = this.hqlAndParametersBuilder.getHql();
        Assert.assertTrue((boolean)actualHql.contains("myProp is null or topiaEntity_.myProp in ("));
        Assert.assertEquals((long)(SOME_VALUES_WITH_NULL.size() - 1), (long)this.hqlAndParametersBuilder.getHqlParameters().size());
    }

    @Test
    public void testAddNotEqualsToValue() {
        this.hqlAndParametersBuilder.addNotEquals("myProp", (Object)"value");
        String actualHql = this.hqlAndParametersBuilder.getHql();
        Assert.assertTrue((boolean)actualHql.contains("myProp != "));
        Assert.assertFalse((boolean)actualHql.contains("myProp = "));
    }

    @Test
    public void testAddNotEqualsToNull() {
        this.hqlAndParametersBuilder.addNotEquals("myProp", null);
        String actualHql = this.hqlAndParametersBuilder.getHql();
        Assert.assertTrue((boolean)actualHql.contains("myProp is not null"));
    }

    @Test
    public void testAddNotInWithNull() {
        this.hqlAndParametersBuilder.addNotIn("myProp", SOME_VALUES_WITH_NULL);
        String actualHql = this.hqlAndParametersBuilder.getHql();
        Assert.assertTrue((boolean)actualHql.contains("myProp is not null and "));
    }
}

