/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.junit;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.nuiton.topia.junit.ConfigurationHelper;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.HibernateProvider;

public abstract class AbstractDatabaseResource<PersistenceContext extends TopiaPersistenceContext, ApplicationContext extends AbstractTopiaApplicationContext<PersistenceContext>>
extends TestWatcher {
    private static final Log log = LogFactory.getLog(AbstractDatabaseResource.class);
    private File testBasedir;
    private Properties dbConfiguration;
    private ApplicationContext applicationContext;
    private Configuration hibernateCfg;
    private final String configurationPath;

    protected abstract ApplicationContext createApplicationContext(Properties var1);

    protected abstract String getImplementationClassesAsString();

    public AbstractDatabaseResource(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void starting(Description description) {
        this.testBasedir = ConfigurationHelper.getTestSpecificDirectory(description.getTestClass(), description.getMethodName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("testBasedir = " + this.testBasedir));
        }
        try {
            this.dbConfiguration = new Properties();
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(this.configurationPath);
            try {
                this.dbConfiguration.load(stream);
            }
            finally {
                stream.close();
            }
            this.dbConfiguration.setProperty("topia.persistence.classes", this.getImplementationClassesAsString());
            String dbPath = new File(this.testBasedir, "db").getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("dbPath = " + dbPath));
            }
            this.dbConfiguration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath);
            this.onDbConfigurationCreate(this.dbConfiguration, this.testBasedir, dbPath);
            this.applicationContext = this.createApplicationContext(this.dbConfiguration);
            Field field = FieldUtils.getField(AbstractTopiaApplicationContext.class, (String)"hibernateProvider", (boolean)true);
            HibernateProvider hibernateProvider = (HibernateProvider)field.get(this.applicationContext);
            this.hibernateCfg = hibernateProvider.getHibernateConfiguration();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start db at " + this.testBasedir, e);
        }
    }

    public void finished(Description description) {
        block3: {
            if (this.applicationContext != null && !this.applicationContext.isClosed()) {
                try {
                    this.applicationContext.closeContext();
                }
                catch (TopiaException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Could not close topia root context", (Throwable)e);
                }
            }
        }
        this.applicationContext = null;
        this.dbConfiguration = null;
        this.hibernateCfg = null;
    }

    public File getTestBasedir() {
        return this.testBasedir;
    }

    public Properties getDbConfiguration() {
        return this.dbConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Configuration getHibernateCfg() {
        return this.hibernateCfg;
    }

    public PersistenceContext beginTransaction() throws TopiaException {
        return (PersistenceContext)this.applicationContext.newPersistenceContext();
    }

    protected void onDbConfigurationCreate(Properties configuration, File testDir, String dbPath) {
    }
}

