package org.nuiton.topia.it.mapping.test14;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.mapping.AbstractTopiaItMappingTopiaDao;
import org.nuiton.topia.it.mapping.TopiaItMappingEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Jul 21 16:58:26 CEST 2014")
public abstract class GeneratedAssoc14CTopiaDao<E extends Assoc14C> extends AbstractTopiaItMappingTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Assoc14C.class;
    }

    @Override
    public TopiaItMappingEntityEnum getTopiaEntityEnum() {
        return TopiaItMappingEntityEnum.Assoc14C;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(B14C b14C, A14C a14C) {
        return create(Assoc14C.PROPERTY_B14_C, b14C, Assoc14C.PROPERTY_A14_C, a14C);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forA14CIn(Collection<A14C> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Assoc14C.PROPERTY_A14_C, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forA14CEquals(A14C v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Assoc14C.PROPERTY_A14_C, v);
        return result;
    }

    @Deprecated
    public E findByA14C(A14C v) {
        return forA14CEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByA14C(A14C v) {
        return forA14CEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAssoc14CTopiaDao<E extends Assoc14C>
