/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Collection;
import org.nuiton.util.BoundedListOutOfBoundsException;

public class BoundedList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -3211387041114409849L;
    private int minSize = 0;
    private int maxSize = -1;

    public boolean isFull() {
        return this.maxSize == -1 || this.size() >= this.maxSize;
    }

    public boolean isToMinimum() {
        return this.size() <= this.minSize;
    }

    public BoundedList(int initialCapacity) {
        super(initialCapacity);
    }

    public BoundedList() {
    }

    public BoundedList(Collection<E> arg0) {
        super(arg0);
    }

    public BoundedList(int minSize, int maxSize) {
        if (minSize > 0) {
            this.minSize = minSize;
        }
        if (minSize > -1) {
            this.maxSize = maxSize;
        }
    }

    @Override
    public boolean add(E o) {
        if (this.checkNewSize(1)) {
            return super.add(o);
        }
        throw this.getException("Cannot add element. Use set to replace element or remove to free space or addAll");
    }

    @Override
    public void add(int index, E o) {
        if (!this.checkNewSize(1)) {
            throw this.getException("Cannot add element. Use set to replace element or remove to free space or addAll");
        }
        super.add(index, o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.checkNewSize(c.size())) {
            return super.addAll(c);
        }
        throw this.getException("Cannot add element. Use set to replace element or remove to free space or addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.checkNewSize(c.size())) {
            return super.addAll(index, c);
        }
        throw this.getException("Cannot add element. Use set to replace element or remove to free space or addAll");
    }

    @Override
    public Object clone() {
        BoundedList bL = (BoundedList)super.clone();
        bL.minSize = this.minSize;
        bL.maxSize = this.maxSize;
        return bL;
    }

    @Override
    public E remove(int index) {
        if (this.checkNewSize(-1)) {
            return super.remove(index);
        }
        throw this.getException("Cannot remove element, minSize is " + this.minSize);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (!this.checkNewSize(-(toIndex - fromIndex))) {
            throw this.getException("Cannot remove element, minSize is " + this.minSize);
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean remove(Object o) {
        if (this.checkNewSize(-1) || !this.contains(o)) {
            return super.remove(o);
        }
        throw this.getException("Cannot remove element, minSize is " + this.minSize);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.checkNewSize(-c.size())) {
            return super.removeAll(c);
        }
        throw this.getException("Cannot remove element, minSize is " + this.minSize);
    }

    private boolean checkNewSize(int size) {
        if (size == 0) {
            return this.size() >= this.minSize && (this.maxSize == -1 || this.size() <= this.maxSize);
        }
        if (size > 0) {
            return this.maxSize == -1 || this.size() + size <= this.maxSize;
        }
        return this.size() + size >= this.minSize;
    }

    private RuntimeException getException(String msg) {
        return new BoundedListOutOfBoundsException(msg);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

