/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.util.PagerBean;

public class PagerBeanUtil {
    public static long getTotalPage(long totalCount, int pageSize) {
        long result = (long)Math.ceil((double)totalCount / (double)pageSize);
        return result;
    }

    public static Pair<Long, Long> getPageBound(long totalCount, int page, int pageSize) {
        page = Math.max(page, 1);
        long pageSize2 = pageSize == -1 ? totalCount : (long)Math.max(pageSize, 1);
        long start = ((long)page - 1L) * pageSize2;
        long end = (long)page * pageSize2;
        end = Math.min(end, totalCount);
        Pair<Long, Long> result = Pair.of(start, end);
        return result;
    }

    public static <E> List<E> getPage(List<E> elements, int page, int pageSize) {
        Pair<Long, Long> bound = PagerBeanUtil.getPageBound(elements.size(), page, pageSize);
        long start = bound.getLeft();
        long end = bound.getRight();
        List<E> subList = elements.subList((int)start, (int)end);
        ArrayList<E> result = new ArrayList<E>(subList);
        return result;
    }

    public static void computeRecordIndexesAndPagesNumber(PagerBean bean) {
        long records = bean.getRecords();
        int pageSize = bean.getPageSize();
        Pair<Long, Long> pageBound = PagerBeanUtil.getPageBound(records, bean.getPageIndex(), pageSize);
        bean.setRecordStartIndex(pageBound.getLeft());
        bean.setRecordEndIndex(pageBound.getRight());
        bean.setPagesNumber(PagerBeanUtil.getTotalPage(records, pageSize));
    }

    public static PagerBean newPagerBean() {
        return new PagerBean();
    }
}

