/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUMapMultiKey
extends LinkedHashMap<Key, Object> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LRUMapMultiKey.class);
    protected Map<Object, Set<Key>> keys = new HashMap<Object, Set<Key>>();
    protected int maxSize;

    public LRUMapMultiKey(int maxSize) {
        super(maxSize <= 0 ? 1000 : maxSize * 100 / 75, 0.75f, true);
        this.maxSize = maxSize;
    }

    public Key createKey(Object ... k) {
        return new Key(k);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public Object remove(Object k) {
        if (k instanceof Key) {
            return super.remove(k);
        }
        ArrayList<Key> result = new ArrayList<Key>();
        Set<Key> list = this.keys.remove(k);
        if (list != null) {
            for (Key key : list) {
                result.add(key);
                super.remove(key);
            }
            list.clear();
        }
        return result;
    }

    @Override
    public Object put(Key key, Object value) {
        for (Object k : key) {
            Set<Key> list = this.keys.get(k);
            if (list == null) {
                list = new HashSet<Key>();
                this.keys.put(k, list);
            }
            list.add(key);
        }
        Object result = super.put(key, value);
        return result;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Key, Object> eldest) {
        if (this.maxSize > 0 && this.size() > this.maxSize) {
            Key key = eldest.getKey();
            for (Object k : key) {
                Set<Key> list = this.keys.get(k);
                if (list == null) continue;
                list.remove(key);
                if (list.size() != 0) continue;
                this.keys.remove(k);
            }
            if (!this.containsKey(eldest.getKey())) {
                log.warn("possible memory leak !!! removeEldestEntry (" + eldest.getKey().getClass() + ")" + eldest.getKey() + " size " + this.size() + " maxSize" + this.maxSize);
            }
            return true;
        }
        return false;
    }

    public static class Key
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
        protected int hash = 0;

        public Key(Object ... k) {
            Collections.addAll(this, k);
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = super.hashCode();
            }
            return this.hash;
        }
    }
}

