/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class URLConverter
implements NuitonConverter<URL> {
    private static final Log LOGGER = LogFactory.getLog(URLConverter.class);

    @Override
    public <T> T convert(Class<T> aClass, Object value) {
        if (value == null) {
            throw new ConversionException(String.format("No value specified for converter %s", this));
        }
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return aClass.cast(result);
            }
            if (value instanceof String) {
                URL result = this.valueOf((String)value);
                return aClass.cast(result);
            }
        }
        throw new ConversionException(String.format("no convertor found for type %2$s and objet '%1$s'", aClass.getName(), value));
    }

    protected URL valueOf(String value) {
        try {
            URL result = new URL(value);
            return result;
        }
        catch (MalformedURLException e) {
            throw new ConversionException(String.format("a problem occurs while converting value '%s' with url convertor %s", value, this), e);
        }
    }

    public URLConverter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("init url converter " + this);
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return URL.class.equals(aClass);
    }

    @Override
    public Class<URL> getType() {
        return URL.class;
    }
}

