/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractPlugin
extends AbstractMojo
implements Plugin {
    protected abstract void init() throws Exception;

    protected abstract void doAction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean canContinue;
            if (this.getLog().isDebugEnabled()) {
                this.setVerbose(true);
            }
            if (!(canContinue = this.checkPackaging())) {
                this.getLog().warn((CharSequence)("The goal is skip due to packaging '" + this.getProject().getPackaging() + "'"));
                return;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not init goal " + this.getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
            canContinue = this.checkSkip();
            if (!canContinue) {
                if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                    this.getLog().info((CharSequence)"Goal will not be executed.");
                }
                return;
            }
            try {
                this.doAction();
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not execute goal " + this.getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
        }
        finally {
            this.afterExecute();
        }
    }

    protected void afterExecute() {
    }

    protected boolean checkPackaging() {
        return true;
    }

    protected boolean checkSkip() {
        return true;
    }

    protected boolean acceptPackaging(Plugin.Packaging ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (Plugin.Packaging p : packages) {
            if (!p.name().equals(projectPackaging)) continue;
            return true;
        }
        return false;
    }

    protected boolean rejectPackaging(Plugin.Packaging ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (Plugin.Packaging p : packages) {
            if (!p.name().equals(projectPackaging)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExecutionRoot() {
        return this.getProject().isExecutionRoot();
    }

    protected boolean checkRunOnceDone(boolean runOnce, boolean onlyForRoot, Date buildStartTime, Date newStartTime) {
        if (!runOnce) {
            return false;
        }
        if (onlyForRoot && !this.isExecutionRoot()) {
            return true;
        }
        if (buildStartTime == null) {
            return false;
        }
        if (newStartTime == null) {
            return false;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("build  timestamp : " + buildStartTime));
            this.getLog().info((CharSequence)("plugin timestamp : " + newStartTime));
        }
        return newStartTime.getTime() > buildStartTime.getTime();
    }

    public File getFileFromBasedir(String ... paths) {
        File result = this.getProject().getBasedir();
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }

    public void copyFile(File srcFile, File destFile) throws IOException {
        this.getLog().info((CharSequence)("Copying " + srcFile.getName() + " to " + destFile));
        PluginHelper.copy(srcFile, destFile);
    }

    public void writeFile(File destFile, String content, String encoding) throws IOException {
        PluginHelper.writeString(destFile, content, encoding);
    }

    protected boolean isFileNewerThanPomFile(File f) {
        File pomFile = this.getProject().getFile();
        return f.exists() && f.lastModified() > pomFile.lastModified();
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files, MirroredFileUpdater updater) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("discovering source files in " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList<String> toTreate = new ArrayList<String>();
            if (updater != null) {
                updater.setSourceDirectory(f);
            }
            for (String filePath : tmp) {
                File srcFile = new File(f, filePath);
                if (updater != null && updater.isFileUpToDate(srcFile)) continue;
                toTreate.add(filePath);
            }
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    protected Map<String, String> getFilesToTreate(String[] includes, String[] excludes, File srcDir, MirroredFileUpdater updater) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        if (!srcDir.exists()) {
            return result;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("discovering files for " + srcDir));
        }
        ds.setBasedir(srcDir);
        ds.scan();
        String[] tmp = ds.getIncludedFiles();
        if (tmp.length < 1) {
            return result;
        }
        ArrayList<String> toTreate = new ArrayList<String>();
        if (updater != null) {
            updater.setSourceDirectory(srcDir);
        }
        for (String filePath : tmp) {
            File srcFile = new File(srcDir, filePath);
            File mirrorFile = updater.getMirrorFile(srcFile);
            if (updater != null && updater.isFileUpToDate(srcFile)) continue;
            result.put(filePath, mirrorFile.getAbsolutePath());
            toTreate.add(filePath);
        }
        if (toTreate.isEmpty()) {
            return result;
        }
        return result;
    }

    protected void addCompileSourceRoots(File srcDir) {
        if (!this.getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("adding source roots : " + srcDir.getPath()));
            }
            this.getProject().addCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeCompileSourceRoots(File srcDir) {
        if (this.getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("removing source roots : " + srcDir.getPath()));
            }
            this.getProject().getCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addTestCompileSourceRoots(File srcDir) {
        if (!this.getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("adding test source roots : " + srcDir.getPath()));
            }
            this.getProject().addTestCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeTestCompileSourceRoots(File srcDir) {
        if (this.getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("removing test source roots : " + srcDir.getPath()));
            }
            this.getProject().getTestCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addResourceDir(File dir, String ... includes) {
        boolean added = PluginHelper.addResourceDir(dir, this.getProject(), includes);
        if (added && this.isVerbose()) {
            this.getLog().info((CharSequence)("add resource " + dir + " with includes " + Arrays.toString(includes)));
        }
    }

    protected void addTestResourceDir(File dir, String ... includes) {
        boolean added = PluginHelper.addTestResourceDir(dir, this.getProject(), includes);
        if (added && this.isVerbose()) {
            this.getLog().info((CharSequence)("add test resource " + dir + " with includes " + Arrays.toString(includes)));
        }
    }

    protected void createDirectoryIfNecessary(File dir) throws IOException {
        boolean b = PluginHelper.createDirectoryIfNecessary(dir);
        if (b && this.isVerbose()) {
            this.getLog().info((CharSequence)("mkdir " + dir));
        }
    }

    protected void createNewFile(File file) throws IOException {
        PluginHelper.createNewFile(file);
    }

    protected void deleteFile(File file) throws IOException {
        PluginHelper.deleteFile(file);
    }

    protected void renameFile(File file, File destination) throws IOException {
        PluginHelper.renameFile(file, destination);
    }

    public File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    protected void backupFile(File f) throws IOException {
        File dst = this.getBackupFile(f);
        this.copyFile(f, dst);
    }

    protected URLClassLoader initClassLoader(MavenProject project, File src, boolean addSourcesToClassPath, boolean testPhase, boolean addResourcesToClassPath, boolean addCompileClassPath, boolean addProjectClassPath) throws MalformedURLException {
        URLClassLoader loader;
        if (project != null) {
            URLClassLoader result;
            try {
                HashSet<String> dones = new HashSet<String>();
                ArrayList<URL> lUrls = new ArrayList<URL>();
                List sources = project.getCompileSourceRoots();
                if (addSourcesToClassPath) {
                    for (String source : sources) {
                        this.addDirectoryToUrlsList(new File(source), lUrls, dones);
                    }
                    if (testPhase) {
                        for (String source : project.getTestCompileSourceRoots()) {
                            this.addDirectoryToUrlsList(new File(source.toString()), lUrls, dones);
                        }
                    }
                }
                if (addResourcesToClassPath) {
                    for (String source : project.getResources()) {
                        Resource r = (Resource)source;
                        this.addDirectoryToUrlsList(new File(r.getDirectory()), lUrls, dones);
                    }
                }
                if (testPhase && addCompileClassPath) {
                    this.addDirectoryToUrlsList(new File(project.getBuild().getOutputDirectory()), lUrls, dones);
                }
                if (src != null) {
                    this.addDirectoryToUrlsList(src, lUrls, dones);
                }
                if (addProjectClassPath) {
                    this.getLog().info((CharSequence)"use project compile scope class-path");
                    Set artifacts = project.getArtifacts();
                    for (Object o : artifacts) {
                        Artifact a = (Artifact)o;
                        this.addDirectoryToUrlsList(a.getFile(), lUrls, dones);
                    }
                }
                result = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), this.getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new RuntimeException("Can't create ClassLoader for reason " + e.getMessage(), e);
            }
            loader = result;
        } else {
            ArrayList<URL> lUrls = new ArrayList<URL>();
            if (addSourcesToClassPath) {
                lUrls.add(src.toURI().toURL());
            }
            loader = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), this.getClass().getClassLoader());
        }
        if (this.isVerbose()) {
            for (URL entry : loader.getURLs()) {
                this.getLog().info((CharSequence)("classpath : " + entry));
            }
        }
        return loader;
    }

    protected void addDirectoryToUrlsList(File directory, List<URL> urls, Set<String> done) throws MalformedURLException {
        this.addUrlToUrlsList(directory.toURI().toURL(), urls, done);
    }

    protected void addUrlToUrlsList(URL url, List<URL> urls, Set<String> done) {
        String u = url.toString();
        if (!done.contains(u)) {
            done.add(u);
            urls.add(url);
        }
    }

    protected URL getTemplate(File f) throws IOException {
        URL r = null;
        r = f.exists() ? f.toURI().toURL() : this.getClass().getResource(f.toString());
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkResource(File f) throws IOException {
        if (!f.exists()) {
            InputStream r = null;
            try {
                r = this.getClass().getResourceAsStream(f.toString());
                if (r == null) {
                    throw new IOException("could not find ressource " + f);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
    }

    protected MavenProject getRootProject(MavenProject project, List reactors) {
        if (project.isExecutionRoot() || reactors.size() == 1 || reactors.get(0).equals(project)) {
            this.getLog().debug((CharSequence)("project " + project + " is root execution :)"));
            return project;
        }
        MavenProject root = (MavenProject)reactors.get(0);
        this.getLog().debug((CharSequence)("first project in reactor : " + root));
        return root;
    }
}

