/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.AbstractMatrixND;
import org.nuiton.math.matrix.BasicMatrix;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixIteratorImpl;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.Vector;

public class MatrixNDImpl
extends AbstractMatrixND {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(MatrixNDImpl.class);
    public static List<Reference<MatrixNDImpl>> allMat = new LinkedList<Reference<MatrixNDImpl>>();
    protected BasicMatrix matrix = null;

    @Override
    public int getNumberOfAssignedValue() {
        return this.matrix.getNumberOfAssignedValue();
    }

    protected MatrixNDImpl(MatrixFactory factory, int[] dim) {
        super(factory, dim);
        this.matrix = new BasicMatrix(factory, dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, List<?>[] semantics) {
        super(factory, semantics);
        this.matrix = new BasicMatrix(factory, this.dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, int[] dim) {
        super(factory, name, dim);
        this.matrix = new BasicMatrix(factory, dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, int[] dim, String[] dimNames) {
        super(factory, name, dim, dimNames);
        this.matrix = new BasicMatrix(factory, dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, int[] dim, String[] dimNames, Vector data) {
        super(factory, name, dim, dimNames);
        this.matrix = new BasicMatrix(factory, data, dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, List<?>[] semantics) {
        super(factory, name, semantics);
        this.matrix = new BasicMatrix(factory, this.dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, List<?>[] semantics, String[] dimNames) {
        super(factory, name, semantics, dimNames);
        this.matrix = new BasicMatrix(factory, this.dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, String name, List<?>[] semantics, String[] dimNames, Vector data) {
        super(factory, name, semantics, dimNames);
        this.matrix = new BasicMatrix(factory, data, this.dim);
    }

    protected MatrixNDImpl(MatrixFactory factory, MatrixND matrix) {
        super(factory, matrix.getName(), matrix.getSemantics(), matrix.getDimensionNames());
        this.matrix = new BasicMatrix(factory, this.dim);
        this.paste(matrix);
    }

    protected MatrixNDImpl(MatrixFactory factory, MatrixND matrix, Vector data) {
        super(factory, matrix.getName(), matrix.getSemantics(), matrix.getDimensionNames());
        this.matrix = new BasicMatrix(factory, data, this.dim);
        this.paste(matrix);
    }

    public BasicMatrix getInternalMatrix() {
        return this.matrix;
    }

    @Override
    public boolean equalsValues(MatrixND mat) {
        boolean result = mat instanceof MatrixNDImpl ? this.matrix.equals(((MatrixNDImpl)mat).matrix) : super.equalsValues(mat);
        return result;
    }

    @Override
    public MatrixIterator iterator() {
        return new MatrixIteratorImpl(this.matrix.iterator(), this.getSemantics());
    }

    @Override
    public MatrixIterator iteratorNotZero() {
        return new MatrixIteratorImpl(this.matrix.iteratorNotZero(), this.getSemantics());
    }

    @Override
    public double getValue(int[] coordinates) {
        return this.matrix.getValue(coordinates);
    }

    @Override
    public void setValue(int[] coordinates, double d) {
        this.matrix.setValue(coordinates, d);
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        return this.matrix.getMaxOccurrence();
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.matrix.toString();
    }

    @Override
    public MatrixND map(MapFunction f) {
        if (this.matrix.data.isImplementedMap()) {
            this.matrix.data.map(f);
        } else {
            super.map(f);
        }
        return this;
    }

    @Override
    public MatrixND paste(int[] origin, MatrixND mat) {
        boolean origin0 = true;
        for (int i = 0; i < origin.length && origin0; ++i) {
            origin0 = origin0 && origin[i] == 0;
        }
        if (origin0 && mat instanceof MatrixNDImpl && Arrays.equals(mat.getDim(), this.getDim()) && this.matrix.data.isImplementedPaste(((MatrixNDImpl)mat).matrix.data)) {
            this.matrix.data.paste(((MatrixNDImpl)mat).matrix.data);
        } else {
            super.paste(origin, mat);
        }
        return this;
    }

    @Override
    public MatrixND pasteSemantics(MatrixND mat) {
        boolean pasteDone = false;
        if (mat instanceof MatrixNDImpl) {
            MatrixNDImpl mImpl = (MatrixNDImpl)mat;
            if (MatrixHelper.sameSemantics(this.semantics, mImpl.semantics) && this.matrix.data.isImplementedPaste(mImpl.matrix.data)) {
                this.matrix.data.paste(mImpl.matrix.data);
                pasteDone = true;
            }
        }
        if (!pasteDone) {
            super.pasteSemantics(mat);
        }
        return this;
    }

    @Override
    public MatrixND add(MatrixND m) {
        if (m instanceof MatrixNDImpl && this.matrix.data.isImplementedAdd(((MatrixNDImpl)m).matrix.data)) {
            this.matrix.data.add(((MatrixNDImpl)m).matrix.data);
        } else {
            super.add(m);
        }
        return this;
    }

    @Override
    public MatrixND minus(MatrixND m) {
        if (m instanceof MatrixNDImpl && this.matrix.data.isImplementedMinus(((MatrixNDImpl)m).matrix.data)) {
            this.matrix.data.minus(((MatrixNDImpl)m).matrix.data);
        } else {
            super.minus(m);
        }
        return this;
    }
}

