/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SplashScreen
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_DURATION = 3000L;
    public static final long DEFAULT_REMANENCE = 5000L;
    public static final int DEFAULT_STEPPING_LEFT_INSET = 100;
    public static final int DEFAULT_STEPPING_RIGHT_INSET = 100;
    public static final int DEFAULT_STEPPING_BOTTOM_INSET = 100;
    public static final Composite defaultComposite = AlphaComposite.getInstance(3, 0.7f);
    protected long remanence = 5000L;
    protected Image splashImage;
    protected String applicationTitle;
    protected long estimatedDuration;
    protected String[] stepDescriptions;
    protected Image[] stepImages;
    protected int currentStep = -1;
    protected int steppingLeftInset = 100;
    protected int steppingRightInset = 100;
    protected int steppingBottomInset = 100;
    protected Image currentImage;
    protected Composite currentComposite;
    protected ImageAnimator imageAnimator;
    protected float currentAlpha = 0.1f;
    protected boolean alphaUp = true;
    protected JPanel jContentPane = null;
    protected JPanel splashPane = null;

    public SplashScreen(String applicationTitle, String splashImagePath) {
        this(applicationTitle, splashImagePath, 3000L);
    }

    public SplashScreen(String applicationTitle, String splashImagePath, long estimatedDuration) {
        this(applicationTitle, splashImagePath, estimatedDuration, null);
    }

    public SplashScreen(String applicationTitle, String splashImagePath, long estimatedDuration, String[] stepDescriptions) {
        this(applicationTitle, splashImagePath, estimatedDuration, stepDescriptions, null);
    }

    public SplashScreen(String applicationTitle, String splashImagePath, String[] stepDescriptions) {
        this(applicationTitle, splashImagePath, 3000L, stepDescriptions, null);
    }

    public SplashScreen(String applicationTitle, String splashImagePath, String[] stepDescriptions, String[] stepImagesPaths) {
        this(applicationTitle, splashImagePath, 3000L, stepDescriptions, stepImagesPaths);
    }

    public SplashScreen(String applicationTitle, String splashImagePath, long estimatedDuration, String[] stepDescriptions, String[] stepIconsPaths) {
        this.applicationTitle = applicationTitle;
        this.estimatedDuration = estimatedDuration;
        this.stepDescriptions = stepDescriptions;
        this.initialize(splashImagePath, stepIconsPaths);
    }

    public String[] getstepDescriptions() {
        return this.stepDescriptions;
    }

    public void setstepDescriptions(String[] stepDescriptions) {
        this.stepDescriptions = stepDescriptions;
    }

    public int getSteppingLeftInset() {
        return this.steppingLeftInset;
    }

    public void setSteppingLeftInset(int steppingLeftInset) {
        this.steppingLeftInset = steppingLeftInset;
    }

    public int getSteppingRightInset() {
        return this.steppingRightInset;
    }

    public void setSteppingRightInset(int steppingRightInset) {
        this.steppingRightInset = steppingRightInset;
    }

    public String getApplicationTitle() {
        return this.applicationTitle;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public Image getSplashImage() {
        return this.splashImage;
    }

    public Image[] getStepImages() {
        return this.stepImages;
    }

    public int getSteppingBottomInset() {
        return this.steppingBottomInset;
    }

    public void setSteppingBottomInset(int steppingBottomInset) {
        this.steppingBottomInset = steppingBottomInset;
    }

    public Composite getCurrentComposite() {
        return this.currentComposite;
    }

    public void setCurrentComposite(Composite currentComposite) {
        this.currentComposite = currentComposite;
    }

    public void nextStep() {
        if (this.imageAnimator != null) {
            this.imageAnimator.cancel();
        }
        this.setCurrentStep(this.getCurrentStep() + 1);
        this.currentAlpha = 0.1f;
        this.currentImage = this.stepImages[this.getCurrentStep()];
        this.imageAnimator = new ImageAnimator();
        new Timer().schedule((TimerTask)this.imageAnimator, 0L, 70L);
        this.repaint();
    }

    public void complete() {
        if (this.imageAnimator != null) {
            this.imageAnimator.cancel();
        }
        new Timer().schedule((TimerTask)new FrameHider(), this.remanence);
        this.repaint();
    }

    protected void animateImage() {
        if ((double)this.currentAlpha <= 0.3) {
            this.alphaUp = true;
        } else if ((double)this.currentAlpha >= 0.7) {
            this.alphaUp = false;
        }
        this.currentAlpha = this.alphaUp ? (float)((double)this.currentAlpha + 0.1) : (float)((double)this.currentAlpha - 0.1);
        this.setCurrentComposite(AlphaComposite.getInstance(3, this.currentAlpha));
        this.repaint();
    }

    protected Image getStepImage(int i) {
        Image image = null;
        image = i == this.currentStep ? this.currentImage : this.stepImages[i];
        return image;
    }

    public Composite getCompositeFor(int step) {
        if (step == this.getCurrentStep()) {
            return this.getCurrentComposite();
        }
        return defaultComposite;
    }

    protected void paintSplash(Graphics g) {
        g.drawImage(this.splashImage, 0, 0, null);
        if (this.stepImages != null) {
            int steppingInset = (this.getSplashImage().getWidth(null) - this.getSteppingLeftInset() - this.getSteppingRightInset()) / (this.stepImages.length + 1);
            int steppingY = this.getSplashImage().getHeight(null) - this.getSteppingBottomInset();
            for (int i = 0; i <= this.currentStep; ++i) {
                Image image = this.getStepImage(i);
                Graphics2D g2 = (Graphics2D)g;
                Composite oldComposite = g2.getComposite();
                g2.setComposite(this.getCompositeFor(i));
                g2.drawImage(image, this.getSteppingLeftInset() + steppingInset * (i + 1) - image.getWidth(null) / 2, steppingY, null);
                g2.setComposite(oldComposite);
            }
        }
    }

    protected void initialize(String splashImagePath, String[] stepIconsPaths) {
        this.initializeUI();
        this.splashImage = this.getImage(splashImagePath);
        this.setUndecorated(true);
        this.positionAtCenter(this.splashImage.getWidth(null), this.splashImage.getHeight(null));
        this.setVisible(true);
        if (stepIconsPaths != null) {
            this.stepImages = new Image[stepIconsPaths.length];
            for (int i = 0; i < stepIconsPaths.length; ++i) {
                this.stepImages[i] = this.getImage(stepIconsPaths[i]);
            }
        }
    }

    protected Image getImage(String imagePath) {
        Image result = null;
        URL imageURL = this.getClass().getResource(imagePath);
        if (imageURL != null) {
            result = new ImageIcon(imageURL).getImage();
        }
        return result;
    }

    protected void positionAtCenter(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
    }

    protected void initializeUI() {
        this.setContentPane(this.getJContentPane());
    }

    protected JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jContentPane.add((Component)this.getSplashPane(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    protected JPanel getSplashPane() {
        if (this.splashPane == null) {
            this.splashPane = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    SplashScreen.this.paintSplash(g);
                }
            };
            this.splashPane.setLayout(new BorderLayout());
        }
        return this.splashPane;
    }

    public static void main(String[] args) {
        SplashScreen f = new SplashScreen("SplashScreen v0.1\n Released under GNU General Public License v2.0", "/redGecko.jpg", new String[0], new String[]{"/64x64/camera.png", "/64x64/joystick.png", "/64x64/modem.png", "/64x64/mouse.png", "/64x64/pda.png", "/64x64/printer.png", "/64x64/scanner.png", "/64x64/tablet.png"});
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            f.nextStep();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        f.complete();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    protected class FrameHider
    extends TimerTask {
        protected FrameHider() {
        }

        @Override
        public void run() {
            SplashScreen.this.setVisible(false);
        }
    }

    protected class ImageAnimator
    extends TimerTask {
        protected ImageAnimator() {
        }

        @Override
        public void run() {
            SplashScreen.this.animateImage();
        }
    }
}

