/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: AbstractBeanValidatorUI.java 2444 2012-07-27 14:34:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.23/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/ui/AbstractBeanValidatorUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

import javax.swing.JComponent;

/**
 * Abstract renderer
 *
 * @author tchemit <chemit@codelutin.com>
 */
public abstract class AbstractBeanValidatorUI extends AbstractLayerUI<JComponent> implements SimpleBeanValidatorListener {

    /** Logger */
    private static final Log log = LogFactory.getLog(AbstractBeanValidatorUI.class);

    private static final long serialVersionUID = 1L;

    /**
     * Actual scope to display in the layer.
     * <p/>
     * This field will be recomputed each time a new event arrived on this
     * field.
     */
    protected NuitonValidatorScope scope;

    /** Field name in validator. */
    protected final String field;

    public AbstractBeanValidatorUI(String field) {
        this.field = field;
        if (log.isDebugEnabled()) {
            log.debug("install " + this + "<field:" + field + ">");
        }
    }

    public NuitonValidatorScope getScope() {
        return scope;
    }

    @Override
    public void onFieldChanged(SimpleBeanValidatorEvent event) {
        if (field.equals(event.getField())) {

            scope = event.getSource().getHighestScope(field);
            if (log.isDebugEnabled()) {
                log.debug("set new scope : " + scope + " to field " + field);
            }
            // ask to repaint the layer
            setDirty(true);
        }
    }

}
