/*
 * #%L
 * JAXX :: Tutorial Data-binding
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 Nuiton
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jaxx.tutorials.databinding;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.tutorials.databinding.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class databinding extends jaxx.runtime.swing.Application implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD = "$JSlider0.style.$JSlider0.getValue() > 100.add";
    private static final String BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE = "$JSlider0.style.$JSlider0.getValue() > 100.remove";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rf1hwR9IAwFFsyIHSHBbzhBASxolVRNLDLEXp91JGZzujDOzsoZg/BP8E/TuxcSbJ+PBswcvxn/BGA9ejW+22xbsGkjcw2Tz5r3vfe993+6b75DVCq7ukjB0VeAb1qHu5o3t7XvNXdoyG1S3FJNGKOg+qTSkGzDq9ePawLVGzZaX4vJSRXSk8Kl/qHq5BiPaPONU71BqDFw+WtHSulTvXy+HMlA91D6pJNRXP3+kX3ovXqcBQonsMjiKc1zVYJJMDdLMMzCOnZ6SEid+G2ko5reR71kbq3Ci9V3SoU/gOeRrkJNEIZiB2ZOPHGFE9aE0kDGBEQaWhGq7fsCM8N2IsA0rRrh2PWJIk/ke0jj8LmUEkjNQMDQ0VUY5Up+0LENX79nsza3ehc0sDArmNm8GBluVDRSPFHTDQ9l1zjyqhrK74ThbwaUjm0YN3YGGgyWnGpBVAYYNTDWGZb+PV13Bp/4S3AJGt78ni1/ef3tX7amcw94TiamHTIrbl0pIqgyzrc93JQ4M46U7RC43oKApR4dHDp5JIFaPr5Ec9rtgy11b7t4iegchsvmvHz5OPvp8CtJVGOGCeFVi82+jPjsKtyC4F8q19YjRmb3TeI5ZbgayhhmOK5rYQHWvx/I6W7EBQlzFTMIq+nyahU+/ivW36711pJDe9D/TByvJPoQc8znzaWT72NGJNh+VmgaeGDg3ycsQm1nGzrwYnVeSJs5Yx+LgFS40DQObNxsxt29zCJRrRkY8AdRIk7Qet5UIfHT/7L5P95yK4ELNi+iH5bapeUB4QOcXFsuL5YWD4W74EeZjKxuY3h+qc1adpXL54FgmeeqTJqdI49yK/U6dWMnVoZYpe46dfE/jK12dHGLwb4Srof+Bme+QkHWCjk1YS4YpIswf0bEd1wkGAAA=";
    private static final Log log = LogFactory.getLog(org.nuiton.jaxx.tutorials.databinding.databinding.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField textField;
    protected databinding tuto = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private javax.swing.JSlider $JSlider0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    public static void main(String[] arg) {
        SwingUtilities.invokeLater(new Runnable() { public void run() { new databinding().setVisible(true); } });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public databinding() {
        $initialize();
    }

    public databinding(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getTextField() {
        return textField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JSlider get$JSlider0() {
        return $JSlider0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTuto() {
        if (!allComponentsCreated) {
            return;
        }
        add(textField, BorderLayout.NORTH);
        add($JButton0, BorderLayout.SOUTH);
        add($JSlider0);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new javax.swing.JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTuto();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        tuto.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("tuto", this);
        createTextField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Button"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JSlider0
        $objectMap.put("$JSlider0", $JSlider0 = new javax.swing.JSlider());
        
        $JSlider0.setName("$JSlider0");
        $JSlider0.setValue(0);
        $JSlider0.setMaximum(200);
        // inline creation of tuto
        setName("tuto");
        setDefaultCloseOperation(3);
        setTitle(_("Data-binding Tutorial"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (textField != null) {
                    $bindingSources.put("textField.getDocument()", textField.getDocument());
                    textField.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    textField.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (textField != null && textField.getText() != null) {
                    $JButton0.setEnabled(textField.getText().length() != 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (textField != null) {
                    javax.swing.text.Document $target = ((javax.swing.text.Document) $bindingSources.remove("textField.getDocument()"));
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    textField.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(javax.swing.event.DocumentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if ($JSlider0 != null) {
                    $bindingSources.put("$JSlider0.getModel()", $JSlider0.getModel());
                    $JSlider0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    $JSlider0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD));
                }
            }
        
            @Override
            public void processDataBinding() {
                if ($JSlider0.getValue() > 100) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(org.nuiton.jaxx.tutorials.databinding.databinding.this, $JSlider0, "background", new jaxx.runtime.css.DataBinding("$JSlider0.background.0"), jaxx.runtime.css.Pseudoclasses.wrap($JSlider0.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        $JSlider0.setBackground((java.awt.Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if ($JSlider0 != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("$JSlider0.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    $JSlider0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if ($JSlider0 != null) {
                    $bindingSources.put("$JSlider0.getModel()", $JSlider0.getModel());
                    $JSlider0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    $JSlider0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!($JSlider0.getValue() > 100)) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(org.nuiton.jaxx.tutorials.databinding.databinding.this, $JSlider0, "background", new jaxx.runtime.css.DataBinding("$JSlider0.background.0"), jaxx.runtime.css.Pseudoclasses.wrap($JSlider0.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        $JSlider0.setBackground((java.awt.Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if ($JSlider0 != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("$JSlider0.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    $JSlider0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE));
                }
            }
        
            public void $pr$u2(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}