/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: JAXXAction.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.19/jaxx-runtime/src/main/java/jaxx/runtime/JAXXAction.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime;

import jaxx.runtime.context.JAXXInitialContext;

/**
 * This is the contract to be realized by any class to be used as Action class for an ui.
 *
 * @author tchemit <chemit@codelutin.com>
 */
public interface JAXXAction {

    /**
     * Prepare the initial context of the ui.
     *
     * @param parentContent the context of the parent of the ui (can be null if no parent is required)
     * @param datas         other datas to inject in initial context
     * @return the {@link JAXXInitialContext} to be injected in the ui via the constructor of the {@link JAXXObject}
     */
    JAXXInitialContext init(JAXXContext parentContent, Object... datas);

}
