/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: ComponentDescriptor.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.17/jaxx-runtime/src/main/java/jaxx/runtime/ComponentDescriptor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime;

import java.io.Serializable;

public class ComponentDescriptor implements Serializable {
    String id;

    String javaClassName;

    String styleClass;

    ComponentDescriptor parent;

    private static final long serialVersionUID = 1L;


    public ComponentDescriptor(String id, String javaClassName, String styleClass, ComponentDescriptor parent) {
        this.id = id;
        this.javaClassName = javaClassName;
        this.styleClass = styleClass;
        this.parent = parent;
    }


    public String getId() {
        return id;
    }


    public String getJavaClassName() {
        return javaClassName;
    }


    public String getStyleClass() {
        return styleClass;
    }


    public ComponentDescriptor getParent() {
        return parent;
    }


    @Override
    public String toString() {
        return "ComponentDescriptor[" + id + ", " + javaClassName + ", " + styleClass + "]";
    }
}