package org.nuiton.jaxx.demo.component.jaxx.widgets.number;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class NumberEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz08TQRSeVlp+FERAiReVhAom4hYSL4rxBy0NNAUb4EDk4rQ7tIvbnXXmrV0uHDx48x/w4NWL4X8gnky8eOV/MOFP8M1uu9vWbkGxh93NvO9975uvM+99/UUSUpAFLqqa5RjALe2Auq4mHAuMOtMKL3Z3X5YPWAVyTFaEYQMXxP/F4iS+R1J6sC6BaHtFZMr4TBnFlGkyZbK8bnOLWW1Ey0UyIuHQZLLGGAC5F5lckTKzHSCXXdsRzVo9Vfeq9ePD0mmM5T7FCXFtlH8Tt33/LwjCXQ8USdzQgUwWD+g7mjGpVUVxwrCquKExtZY1qZSbtM7ekiMyWCRJmwokA/Lgn+zx6Dwq1waSSudYnZeoxcxFINnuLegY1CotNn+tYehVBhJx9TIT2qb3WtUxSSgu2/bYk0ASda4zE8jaf2DdUFQh9WB6h5ZNhpJno1yXDfRQ82AqaTjIvW21cWe5tW9UHUHB4JZng0JNqMd4kDEua7xR4rZjrziAhYDcUH+M26xRyNZY5c0KdxV8sjNri0kGfpZanu6CUAd4G3EPyJRhAasy4Rviy8XT0lG/SMu+7jDtekdaiQIwgbqnO/J2mAt5g5l6v9xVS1mo95A2sW9yCu3CVOBWJ2iyDdSUoSIz0ajogpM6dzB0TsWpdlR0yQ5YdM2hdKF1OzpNDw5LeE7Gmsb5Rwv+7Ah9DrmiyARMKc+PMPKwMzzqa4+MpwSTjgmBxKUunX543VcbWPioOz+vRPQIj/rhnCeiPS7IXNR1xKarhU037H+xPZIQDi7jVY7u96plbyHKb9az0c1alfGA74+PxJfG2WmrQydR3Mx5WW3DCNulLbjNBBhK27jfnh0wzMwGtZf3yLBkJk4yb1LN91e+3USielQxoZg0xaStUVlDtsTg6cm36dc/r5B4noyg6XqeKvw6GYYael3jpu7az5574kYbQ/i8pmQCSZr0kGPrIFef6BToTNmwdDydT110ab6/S4Go45dn3z9/vHvSciqGGtMXyQzdSrwiScMyDYt506w5qHpOr5QtmaPzcAr1mksx9R6xm/0+7z0LvfY/ANjCVHTDddRr09Ovvkoex51zOdTyTh+GuUszLFyIodiHYfHSDI+R4Tc6i5BLngkAAA==";
    private static final Log log = LogFactory.getLog(NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoPopupButton;
    protected NumberEditor doubleEditor;
    protected JLabel doubleNumberConfig;
    protected JCheckBox doubleNumberEnabled;
    protected JTextField doubleNumberPattern;
    protected NumberEditor floatEditor;
    protected JLabel floatNumberConfig;
    protected JCheckBox floatNumberEnabled;
    protected JTextField floatNumberPattern;
    protected NumberEditorDemoHandler handler;
    protected NumberEditor integerEditor;
    protected JLabel integerNumberConfig;
    protected JCheckBox integerNumberEnabled;
    protected JTextField integerNumberPattern;
    protected NumberEditorDemoModel model;
    protected Table numberEditorConfigurationPanel;
    protected JLabel resultDouble;
    protected JLabel resultFloat;
    protected JLabel resultInteger;
    protected JPanel resultPanel;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumberEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo() {
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoPopupButton() {
        return autoPopupButton;
    }

    public NumberEditor getDoubleEditor() {
        return doubleEditor;
    }

    public JLabel getDoubleNumberConfig() {
        return doubleNumberConfig;
    }

    public JCheckBox getDoubleNumberEnabled() {
        return doubleNumberEnabled;
    }

    public JTextField getDoubleNumberPattern() {
        return doubleNumberPattern;
    }

    public NumberEditor getFloatEditor() {
        return floatEditor;
    }

    public JLabel getFloatNumberConfig() {
        return floatNumberConfig;
    }

    public JCheckBox getFloatNumberEnabled() {
        return floatNumberEnabled;
    }

    public JTextField getFloatNumberPattern() {
        return floatNumberPattern;
    }

    public NumberEditorDemoHandler getHandler() {
        return handler;
    }

    public NumberEditor getIntegerEditor() {
        return integerEditor;
    }

    public JLabel getIntegerNumberConfig() {
        return integerNumberConfig;
    }

    public JCheckBox getIntegerNumberEnabled() {
        return integerNumberEnabled;
    }

    public JTextField getIntegerNumberPattern() {
        return integerNumberPattern;
    }

    public NumberEditorDemoModel getModel() {
        return model;
    }

    public Table getNumberEditorConfigurationPanel() {
        return numberEditorConfigurationPanel;
    }

    public JLabel getResultDouble() {
        return resultDouble;
    }

    public JLabel getResultFloat() {
        return resultFloat;
    }

    public JLabel getResultInteger() {
        return resultInteger;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNumberEditorConfigurationPanel() {
        numberEditorConfigurationPanel.add(showPopupButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(showResetButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(autoPopupButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberConfig, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberPattern, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberEnabled, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberConfig, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberPattern, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberEnabled, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberConfig, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberPattern, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberEnabled, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(resultInteger);
        resultPanel.add(resultFloat);
        resultPanel.add(resultDouble);
    }

    protected void createAutoPopupButton() {
        $objectMap.put("autoPopupButton", autoPopupButton = new JCheckBox());
        
        autoPopupButton.setName("autoPopupButton");
    }

    protected void createDoubleEditor() {
        $objectMap.put("doubleEditor", doubleEditor = new NumberEditor(this));
        
        doubleEditor.setName("doubleEditor");
    }

    protected void createDoubleNumberConfig() {
        $objectMap.put("doubleNumberConfig", doubleNumberConfig = new JLabel());
        
        doubleNumberConfig.setName("doubleNumberConfig");
    }

    protected void createDoubleNumberEnabled() {
        $objectMap.put("doubleNumberEnabled", doubleNumberEnabled = new JCheckBox());
        
        doubleNumberEnabled.setName("doubleNumberEnabled");
    }

    protected void createDoubleNumberPattern() {
        $objectMap.put("doubleNumberPattern", doubleNumberPattern = new JTextField());
        
        doubleNumberPattern.setName("doubleNumberPattern");
        doubleNumberPattern.setColumns(15);
    }

    protected void createFloatEditor() {
        $objectMap.put("floatEditor", floatEditor = new NumberEditor(this));
        
        floatEditor.setName("floatEditor");
    }

    protected void createFloatNumberConfig() {
        $objectMap.put("floatNumberConfig", floatNumberConfig = new JLabel());
        
        floatNumberConfig.setName("floatNumberConfig");
    }

    protected void createFloatNumberEnabled() {
        $objectMap.put("floatNumberEnabled", floatNumberEnabled = new JCheckBox());
        
        floatNumberEnabled.setName("floatNumberEnabled");
    }

    protected void createFloatNumberPattern() {
        $objectMap.put("floatNumberPattern", floatNumberPattern = new JTextField());
        
        floatNumberPattern.setName("floatNumberPattern");
        floatNumberPattern.setColumns(15);
    }

    protected void createIntegerEditor() {
        $objectMap.put("integerEditor", integerEditor = new NumberEditor(this));
        
        integerEditor.setName("integerEditor");
    }

    protected void createIntegerNumberConfig() {
        $objectMap.put("integerNumberConfig", integerNumberConfig = new JLabel());
        
        integerNumberConfig.setName("integerNumberConfig");
    }

    protected void createIntegerNumberEnabled() {
        $objectMap.put("integerNumberEnabled", integerNumberEnabled = new JCheckBox());
        
        integerNumberEnabled.setName("integerNumberEnabled");
    }

    protected void createIntegerNumberPattern() {
        $objectMap.put("integerNumberPattern", integerNumberPattern = new JTextField());
        
        integerNumberPattern.setName("integerNumberPattern");
        integerNumberPattern.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorDemoModel.class));
    }

    protected void createNumberEditorConfigurationPanel() {
        $objectMap.put("numberEditorConfigurationPanel", numberEditorConfigurationPanel = new Table());
        
        numberEditorConfigurationPanel.setName("numberEditorConfigurationPanel");
    }

    protected void createResultDouble() {
        $objectMap.put("resultDouble", resultDouble = new JLabel());
        
        resultDouble.setName("resultDouble");
    }

    protected void createResultFloat() {
        $objectMap.put("resultFloat", resultFloat = new JLabel());
        
        resultFloat.setName("resultFloat");
    }

    protected void createResultInteger() {
        $objectMap.put("resultInteger", resultInteger = new JLabel());
        
        resultInteger.setName("resultInteger");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new GridLayout(0,1));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new NumberEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberEditorConfigurationPanel();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopupButton();
        createIntegerNumberConfig();
        createIntegerNumberPattern();
        createIntegerNumberEnabled();
        createFloatNumberConfig();
        createFloatNumberPattern();
        createFloatNumberEnabled();
        createDoubleNumberConfig();
        createDoubleNumberPattern();
        createDoubleNumberEnabled();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createIntegerEditor();
        createFloatEditor();
        createDoubleEditor();
        createResultPanel();
        createResultInteger();
        createResultFloat();
        createResultDouble();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(numberEditorConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToNumberEditorConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(integerEditor);
        $JPanel0.add(floatEditor);
        $JPanel0.add(doubleEditor);
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 6 property setters
        SwingUtil.setText(integerNumberPattern, "-?\\d{0,3}");
        
        SwingUtil.setText(floatNumberPattern, "\\d{0,1}.\\d{0,2}");
        
        SwingUtil.setText(doubleNumberPattern, "-?\\d{0,4}.\\d{0,6}");
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}