package jaxx.demo.feature.databinding;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseBeanDataBinding extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CONTENT_MESSAGE = "contentMessage";
    public static final String PROPERTY_EDITING = "editing";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Ru07DQBDcWHkgIiIeEoqEkHjVNtCmwokokHkImkiujngJjuzzcbdGpkF8Ap8APSUd30HHLyDEDyDOdhITQILrbnZndnbn4RUqSsLqgCWJKWNOfojm3k63e3g6wB51UPWkLyiSkL+SAYYLdW+MK4J110np1pButaNQRBz5F3bLgWlFVwGqc0QiWJ5k9JSyTsblViJiOVIdm/pN9e79zbj1bu4NgERod2W9yspfrGKTsgOG7xHM60mXzAoY72sb0ud97XcmxdoBU+qAhXgB11BzoCqY1GIEa/9fOdPI+IkgqG90MIyOGMdgk2ArM+tpxDxDRrFE02PETn3uaRemzRTayHhHY3aOCZFpVQlq6PmkEYK51KqZ2jftKAo0oeiaGnZtp/9GgTd6ESdteB+VYn0kmC1E8hvoXglLE9fUOZlFTsUhSy5UZKxhgqb7M9pjXcpDbX4LNRXMqh+LC89PL4+7oyThE/3djQ2ZAgAA";
    private static final Log log = LogFactory.getLog(BaseBeanDataBinding.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String contentMessage;
    protected Boolean editing;
    protected Boolean editing2;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BaseBeanDataBinding $DemoPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup(){
        }
    
        public Boolean isEditing2() {
        return editing2;
        }
    
        public void setEditing2(Boolean editing2) {
        Boolean oldValue = this.editing2;
        this.editing2 = editing2;
        firePropertyChange("editing2", oldValue, editing2);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BaseBeanDataBinding(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BaseBeanDataBinding(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BaseBeanDataBinding(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BaseBeanDataBinding(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BaseBeanDataBinding() {
        $initialize();
    }

    public BaseBeanDataBinding(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BaseBeanDataBinding(boolean param0) {
        super(param0);
        $initialize();
    }

    public BaseBeanDataBinding(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getContentMessage() {
        return contentMessage;
    }

    public Boolean getEditing() {
        return editing;
    }

    public Boolean getEditing2() {
        return editing2;
    }

    public Boolean isEditing() {
        return editing !=null && editing;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setContentMessage(String contentMessage) {
        String oldValue = this.contentMessage;
        this.contentMessage = contentMessage;
        firePropertyChange(PROPERTY_CONTENT_MESSAGE, oldValue, contentMessage);
    }

    public void setEditing(Boolean editing) {
        Boolean oldValue = this.editing;
        this.editing = editing;
        firePropertyChange(PROPERTY_EDITING, oldValue, editing);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createContentMessage() {
        $objectMap.put("contentMessage", contentMessage = "message...");
    }

    protected void createEditing() {
        $objectMap.put("editing", editing = false);
    }

    protected void createEditing2() {
        $objectMap.put("editing2", editing2 = new Boolean(false));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createEditing();
        createEditing2();
        createContentMessage();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

}
