package org.nuiton.eugene.test.beangen;
 
 import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class Voiture {

    /**
     * attrA of BeanA
     */
    public int immatriculation;
    public String modele;
    public PersonneDTO proprietaire;
    public Collection<Roue> roue;
    public Collection<Siege> siege;
    protected final PropertyChangeSupport pcs;

    /**
     * Default constructor of Voiture.
     */
    public Voiture() {
        pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    public int getImmatriculation() {
        return immatriculation;
    }

    public String getModele() {
        return modele;
    }

    public PersonneDTO getProprietaire() {
        return proprietaire;
    }

    public Collection<Roue> getRoue() {
        return roue;
    }

    public Collection<Siege> getSiege() {
        return siege;
    }

    public void setImmatriculation(int newValue) {
        int oldValue = getImmatriculation();
        this.immatriculation = newValue;
        firePropertyChange("immatriculation", oldValue, newValue);
    }

    public void setModele(String newValue) {
        String oldValue = getModele();
        this.modele = newValue;
        firePropertyChange("modele", oldValue, newValue);
    }

    public void setProprietaire(PersonneDTO newValue) {
        PersonneDTO oldValue = getProprietaire();
        this.proprietaire = newValue;
        firePropertyChange("proprietaire", oldValue, newValue);
    }

    public void setRoue(Collection<Roue> newValue) {
        Collection<Roue> oldValue = getRoue();
        this.roue = newValue;
        firePropertyChange("roue", oldValue, newValue);
    }

    public void setSiege(Collection<Siege> newValue) {
        Collection<Siege> oldValue = getSiege();
        this.siege = newValue;
        firePropertyChange("siege", oldValue, newValue);
    }

    public Roue getRoue(int index) {
 	    Roue o = getChild(roue, index);
        return o;
    }

    public Siege getSiege(int index) {
 	    Siege o = getChild(siege, index);
        return o;
    }

    public Roue addRoue(Roue roue) {
 	    getRoue().add(roue);
        firePropertyChange("roue", null, roue);
        return roue;
    }

    public Siege addSiege(Siege siege) {
 	    getSiege().add(siege);
        firePropertyChange("siege", null, siege);
        return siege;
    }

    public boolean removeRoue(Roue roue) {
        boolean  removed = getRoue().remove(roue);
        if (removed) {
            firePropertyChange("roue", roue, null);
        }
        return removed;
    }

    public boolean removeSiege(Siege siege) {
        boolean  removed = getSiege().remove(siege);
        if (removed) {
            firePropertyChange("siege", siege, null);
        }
        return removed;
    }


    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         append("immatriculation", this.immatriculation).
         append("modele", this.modele).
         append("proprietaire", this.proprietaire).
         append("roue", this.roue).
         append("siege", this.siege).
         toString();
        return result;
    }
 
    
    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

 
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
      pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

} //Voiture
