package org.nuiton.eugene.test.beangen;
 
 import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class Roue {

    /**
     */
    public abstract void mount();

    /**
     * @param id null
      */
    public abstract int getModel(java.lang.String id);

    public Voiture voiture;
    protected final PropertyChangeSupport pcs;

    /**
     * Default constructor of Roue.
     */
    public Roue() {
        pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    public Voiture getVoiture() {
        return voiture;
    }

    public void setVoiture(Voiture newValue) {
        Voiture oldValue = getVoiture();
        this.voiture = newValue;
        firePropertyChange("voiture", oldValue, newValue);
    }


    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         append("voiture", this.voiture).
         toString();
        return result;
    }
 
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
      pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

} //Roue
