package org.nuiton.eugene.test.beangen;
 
 import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonneDTO implements java.io.Serializable {

    public String name;
    public Collection<String> otherNames;
    protected final PropertyChangeSupport pcs;

    /**
     * Default constructor of PersonneDTO.
     */
    public PersonneDTO() {
        pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    public String getName() {
        return name;
    }

    public Collection<String> getOtherNames() {
        return otherNames;
    }

    public void setName(String newValue) {
        String oldValue = getName();
        this.name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }

    public void setOtherNames(Collection<String> newValue) {
        Collection<String> oldValue = getOtherNames();
        this.otherNames = newValue;
        firePropertyChange("otherNames", oldValue, newValue);
    }


    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         toString();
        return result;
    }
 
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
      pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

} //PersonneDTO
