package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

import java.util.Set;

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @plexus.component role="org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider" role-hint="eugene-java-templates"
 * @since 2.5.6
 */
public class JavaBeanTransformerTagValues extends DefaultTagValueMetadatasProvider {

    @Override
    public String getDescription() {
        return t("eugene.javaBeanTransformer.tagvalues");
    }

    public enum Store implements TagValueMetadata {

        /**
         * Tag value to use a super class for generated bean.
         *
         * If the bean needs Property change support (says you use the {@link EugeneJavaTagValues.Store#generatePropertyChangeSupport}),
         * then your class must provide everything for it.
         *
         * More over, if you use some collections in your bean you must also define
         * two method named {@code getChild(Collection list, int index)} and
         * {@code getChild(List list, int index)}
         *
         * See new code to know minimum stuff to add in your class for this purpose.
         * <pre>
         * public abstract class AbstractBean implements Serializable {
         *
         *     private static final long serialVersionUID = 1L;
         *
         *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
         *
         *     public void addPropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(listener);
         *     }
         *
         *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(propertyName, listener);
         *     }
         *
         *     public void removePropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(listener);
         *     }
         *
         *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(propertyName, listener);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
         *         pcs.firePropertyChange(propertyName, oldValue, newValue);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object newValue) {
         *         firePropertyChange(propertyName, null, newValue);
         *     }
         *
         *     protected &lt;T&gt; T getChild(Collection&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         *
         *     protected &lt;T&gt; T getChild(List&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         * }
         * </pre>
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.5.6
         */
        beanSuperClass(n("eugene.javaBeanTransformer.tagvalue.beanSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class);
        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String defaultValue;

        Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?>... targets) {
            this.targets = ImmutableSet.copyOf(targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return name();
        }

        @Override
        public Set<Class<?>> getTargets() {
            return targets;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        @Override
        public String getDescription() {
            return t(i18nDescriptionKey);
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

    }

    public JavaBeanTransformerTagValues() {
        super((TagValueMetadata[]) Store.values());
    }

    /**
     * Obtain the value of the {@link Store#beanSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#beanSuperClass
     * @since 2.3
     */
    public String getBeanSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.beanSuperClass, classifier, aPackage, model);
    }

}
