/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.JavaTemplatesStereoTypes;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class JavaBeanTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(JavaBeanTransformer.class);

    public void transformFromClass(ObjectModelClass input) {
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        if (!JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input, aPackage)) {
            return;
        }
        ObjectModelClass output = null;
        if (this.canGenerateAbstract(input)) {
            output = this.generateAbstract(aPackage, input);
        }
        if (this.canGenerateImpl(input, output)) {
            this.generateImpl(input);
        }
    }

    protected boolean canGenerateAbstract(ObjectModelClass input) {
        boolean b = !this.isInClassPath((ObjectModelClassifier)input);
        return b;
    }

    protected boolean canGenerateImpl(ObjectModelClass input, ObjectModelClass abstractOutput) {
        String fqn = input.getQualifiedName() + "Impl";
        if (this.isInClassPath(fqn)) {
            return false;
        }
        Collection operations = input.getOperations();
        if (!operations.isEmpty()) {
            return false;
        }
        Collection allOtherOperations = input.getAllOtherOperations(true);
        if (!allOtherOperations.isEmpty()) {
            ArrayList allExistingOperations = new ArrayList(input.getAllSuperclassOperations(true));
            if (abstractOutput != null) {
                allExistingOperations.addAll(abstractOutput.getOperations());
            }
            for (ObjectModelOperation operation : allOtherOperations) {
                if (allExistingOperations.contains(operation)) continue;
                return false;
            }
        }
        return true;
    }

    protected void createAbstractOperations(ObjectModelClass ouput, Iterable<ObjectModelOperation> operations) {
        JavaGeneratorUtil.cloneOperations((ObjectModelTransformerToJava)this, operations, (ObjectModelClassifier)ouput, (boolean)true, (ObjectModelModifier[])new ObjectModelModifier[]{ObjectModelJavaModifier.ABSTRACT});
    }

    protected ObjectModelClass generateAbstract(ObjectModelPackage aPackage, ObjectModelClass input) {
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (!JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass, aPackage)) continue;
                superClassIsBean = true;
                break;
            }
        }
        String superClass = null;
        if (!superClassIsBean && (superClass = this.getJavaTemplatesTagValues().getBeanSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createAbstractClass(input.getName(), input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        this.addSuperClass(input, output);
        boolean serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
        if (superClassIsBean) {
            serializableFound = true;
        }
        this.addSerializable(input, output, serializableFound);
        this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        boolean usePCS = this.getJavaTemplatesTagValues().isGeneratePropertyChangeSupport((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = this.getEugeneTagValues().isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateNotEmptyCollections = this.getJavaTemplatesTagValues().isGenerateNotEmptyCollections((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods, generateNotEmptyCollections);
        }
        this.createAbstractOperations(output, input.getOperations());
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected ObjectModelClass generateImpl(ObjectModelClass input) {
        ObjectModelClass resultClassImpl = this.createClass(input.getName() + "Impl", input.getPackageName());
        this.setSuperClass(resultClassImpl, input.getQualifiedName());
        this.addConstant((ObjectModelClassifier)resultClassImpl, "serialVersionUID", "long", "1L", (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
        return resultClassImpl;
    }

    protected void addSuperClass(ObjectModelClass input, ObjectModelClass output) {
        Iterator j = input.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClass p = (ObjectModelClass)j.next();
            String qualifiedName = p.getQualifiedName() + "Impl";
            this.setSuperClass(output, qualifiedName);
        }
    }
}

