package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: AbstractJavaBeanTransformer.java 1218 2012-12-10 03:11:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.6/eugene-java-templates/src/main/java/org/nuiton/eugene/java/AbstractJavaBeanTransformer.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */





import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * Common class form javabean like transformer.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see SimpleJavaBeanTransformer
 * @see JavaBeanTransformer
 * @since 2.6
 */
public abstract class AbstractJavaBeanTransformer extends ObjectModelTransformerToJava {

    public static final String DEFAULT_CONSTANT_PREFIX = "PROPERTY_";

    protected void createPropertyConstant(ObjectModelClass output,
                                          ObjectModelAttribute attr,
                                          String prefix,
                                          Set<String> constantNames) {

        String attrName = getAttributeName(attr);

        String constantName = prefix + builder.getConstantName(attrName);

        if (!constantNames.contains(constantName)) {

            addConstant(output,
                        constantName,
                        String.class,
                        "\"" + attrName + "\"",
                        ObjectModelJavaModifier.PUBLIC
            );
        }
    }

    protected String getAttributeName(ObjectModelAttribute attr) {
        String attrName = attr.getName();
        if (attr.hasAssociationClass()) {
            String assocAttrName = JavaGeneratorUtil.getAssocAttrName(attr);
            attrName = JavaGeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
        }
        return attrName;
    }

    protected String getAttributeType(ObjectModelAttribute attr) {
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            attrType = attr.getAssociationClass().getName();
        }
        return attrType;
    }

    protected boolean containsMutiple(List<ObjectModelAttribute> attributes) {

        boolean result = false;

        for (ObjectModelAttribute attr : attributes) {

            if (JavaGeneratorUtil.isNMultiplicity(attr)) {
                result = true;

                break;
            }

        }
        return result;
    }

    protected void createProperty(ObjectModelClass output,
                                  ObjectModelAttribute attr,
                                  boolean usePCS,
                                  boolean generateBooleanGetMethods) {

        String attrName = getAttributeName(attr);
        String attrType = getAttributeType(attr);

        boolean multiple = JavaGeneratorUtil.isNMultiplicity(attr);

        String constantName = getConstantName(attrName);
        String simpleType = JavaGeneratorUtil.getSimpleName(attrType);

        if (multiple) {

            createGetChildMethod(output,
                                 attrName,
                                 attrType,
                                 simpleType
            );

            createIsEmptyMethod(output,
                                attrName
            );

            createSizeMethod(output,
                             attrName
            );

            createAddChildMethod(output,
                                 attrName,
                                 attrType,
                                 constantName,
                                 usePCS
            );

            createAddAllChildrenMethod(output,
                                       attrName,
                                       attrType,
                                       constantName,
                                       usePCS
            );

            createRemoveChildMethod(output,
                                    attrName,
                                    attrType,
                                    constantName,
                                    usePCS
            );

            createRemoveAllChildrenMethod(output,
                                          attrName,
                                          attrType,
                                          constantName,
                                          usePCS
            );

            createContainsChildMethod(output,
                                      attrName,
                                      attrType,
                                      constantName,
                                      usePCS
            );

            createContainsAllChildrenMethod(output,
                                            attrName,
                                            attrType,
                                            constantName,
                                            usePCS
            );

            // Change type for Multiple attribute
            if (attr.isOrdered()) {
                attrType = List.class.getName() + "<" + attrType + ">";
            } else {
                attrType = Collection.class.getName() + "<" + attrType + ">";
            }

            simpleType = JavaGeneratorUtil.getSimpleName(attrType);
        }

        boolean booleanProperty = JavaGeneratorUtil.isBooleanPrimitive(attr);

        if (booleanProperty && !multiple) {

            // creates a isXXX method
            createGetMethod(output,
                            attrName,
                            attrType,
                            JavaGeneratorUtil.OPERATION_GETTER_BOOLEAN_PREFIX
            );
        }

        if (multiple || !booleanProperty || generateBooleanGetMethods) {

            createGetMethod(output,
                            attrName,
                            attrType,
                            JavaGeneratorUtil.OPERATION_GETTER_DEFAULT_PREFIX
            );

        }
        createSetMethod(output,
                        attrName,
                        attrType,
                        simpleType,
                        constantName,
                        usePCS
        );

        // Add attribute to the class
        addAttribute(output,
                     attrName,
                     attrType,
                     "",
                     ObjectModelJavaModifier.PROTECTED
        );

    }

    protected List<ObjectModelAttribute> getProperties(ObjectModelClass input) {
        List<ObjectModelAttribute> attributes =
                (List<ObjectModelAttribute>) input.getAttributes();

        List<ObjectModelAttribute> attrs =
                new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : attributes) {
            if (attr.isNavigable()) {

                // only keep navigable attributes
                attrs.add(attr);
            }
        }
        return attrs;
    }

    protected void createGetMethod(ObjectModelClass output,
                                   String attrName,
                                   String attrType,
                                   String methodPrefix) {

        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName(methodPrefix , attrName),
                attrType,
                ObjectModelJavaModifier.PUBLIC
        );
        setOperationBody(operation, ""
    +"\n"
+"        return "+attrName+";\n"
+"    "
        );
    }

    protected void createGetChildMethod(ObjectModelClass output,
                                        String attrName,
                                        String attrType,
                                        String simpleType) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("get", attrName),
                attrType,
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, "int", "index");
        setOperationBody(operation, ""
    +"\n"
+"        "+simpleType+" o = getChild("+attrName+", index);\n"
+"        return o;\n"
+"    "
        );
    }

    protected void createIsEmptyMethod(ObjectModelClass output,
                                       String attrName) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("is", attrName)+"Empty",
                boolean.class,
                ObjectModelJavaModifier.PUBLIC
        );
        setOperationBody(operation, ""
    +"\n"
+"        return "+attrName+" == null || "+attrName+".isEmpty();\n"
+"    "
        );
    }

    protected void createSizeMethod(ObjectModelClass output,
                                    String attrName) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("size", attrName),
                int.class,
                ObjectModelJavaModifier.PUBLIC
        );
        setOperationBody(operation, ""
    +"\n"
+"        return "+attrName+" == null ? 0 : "+attrName+".size();\n"
+"    "
        );
    }
    protected void createAddChildMethod(ObjectModelClass output,
                                        String attrName,
                                        String attrType,
                                        String constantName,
                                        boolean usePCS) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("add", attrName),
                "void",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, attrType, attrName);

        String methodName = getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder(""
    +"\n"
+"        "+methodName+"().add("+attrName+");\n"
+"    "
        );
        if (usePCS) {
            buffer.append(""
    +"    firePropertyChange("+constantName+", null, "+attrName+");\n"
+"    "
            );
        }
        setOperationBody(operation, buffer.toString());
    }

    protected void createAddAllChildrenMethod(ObjectModelClass output,
                                              String attrName,
                                              String attrType,
                                              String constantName,
                                              boolean usePCS) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("addAll", attrName),
                "void",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);

        String methodName = getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder(""
    +"\n"
+"        "+methodName+"().addAll("+attrName+");\n"
+"    "
        );
        if (usePCS) {
            buffer.append(""
    +"    firePropertyChange("+constantName+", null, "+attrName+");\n"
+"    "
            );
        }
        setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveChildMethod(ObjectModelClass output,
                                           String attrName,
                                           String attrType,
                                           String constantName,
                                           boolean usePCS) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("remove", attrName),
                "boolean",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, attrType, attrName);
        String methodName = getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder();
        buffer.append(""
    +"\n"
+"        boolean removed = "+methodName+"().remove("+attrName+");"
        );

        if (usePCS) {
            buffer.append(""
    +"\n"
+"        if (removed) {\n"
+"            firePropertyChange("+constantName+", "+attrName+", null);\n"
+"        }"
            );
        }
        buffer.append(""
    +"\n"
+"        return removed;\n"
+"    "
        );
        setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveAllChildrenMethod(ObjectModelClass output,
                                                 String attrName,
                                                 String attrType,
                                                 String constantName,
                                                 boolean usePCS) {

        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("removeAll", attrName),
                "boolean",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = getJavaBeanMethodName("get", attrName);
        buffer.append(""
    +"\n"
+"        boolean  removed = "+methodName+"().removeAll("+attrName+");"
        );

        if (usePCS) {
            buffer.append(""
    +"\n"
+"        if (removed) {\n"
+"            firePropertyChange("+constantName+", "+attrName+", null);\n"
+"        }"
            );
        }
        buffer.append(""
    +"\n"
+"        return removed;\n"
+"    "
        );
        setOperationBody(operation, buffer.toString());
    }

    protected void createContainsChildMethod(ObjectModelClass output,
                                             String attrName,
                                             String attrType,
                                             String constantName,
                                             boolean usePCS) {

        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("contains", attrName),
                "boolean",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, attrType, attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = getJavaBeanMethodName("get", attrName);
        buffer.append(""
    +"\n"
+"        boolean contains = "+methodName+"().contains("+attrName+");\n"
+"        return contains;\n"
+"    "
        );
        setOperationBody(operation, buffer.toString());
    }

    protected void createContainsAllChildrenMethod(ObjectModelClass output,
                                                   String attrName,
                                                   String attrType,
                                                   String constantName,
                                                   boolean usePCS) {

        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("containsAll", attrName),
                "boolean",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = getJavaBeanMethodName("get", attrName);
        buffer.append(""
    +"\n"
+"        boolean  contains = "+methodName+"().containsAll("+attrName+");\n"
+"        return contains;\n"
+"    "
        );
        setOperationBody(operation, buffer.toString());
    }

    protected void createSetMethod(ObjectModelClass output,
                                   String attrName,
                                   String attrType,
                                   String simpleType,
                                   String constantName,
                                   boolean usePCS) {
        ObjectModelOperation operation = addOperation(
                output,
                getJavaBeanMethodName("set", attrName),
                "void",
                ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, attrType, attrName);

        if (usePCS) {
            String methodName = getJavaBeanMethodName("get", attrName);
            setOperationBody(operation, ""
    +"\n"
+"        "+simpleType+" oldValue = "+methodName+"();\n"
+"        this."+attrName+" = "+attrName+";\n"
+"        firePropertyChange("+constantName+", oldValue, "+attrName+");\n"
+"    "
            );
        } else {
            setOperationBody(operation, ""
    +"\n"
+"        this."+attrName+" = "+attrName+";\n"
+"    "
            );
        }
    }

    protected void addSerializable(ObjectModelClass input,
                                   ObjectModelClass output,
                                   boolean interfaceFound) {
        if (!interfaceFound) {
            addInterface(output, Serializable.class);
        }

        // Generate the serialVersionUID
        long serialVersionUID = JavaGeneratorUtil.generateSerialVersionUID(input);

        addConstant(output,
                    JavaGeneratorUtil.SERIAL_VERSION_UID,
                    "long",
                    serialVersionUID + "L",
                    ObjectModelJavaModifier.PRIVATE
        );
    }

    /**
     * Add all interfaces defines in input class and returns if
     * {@link Serializable} interface was found.
     *
     * @param input the input model class to process
     * @param output the output generated class
     * @return {@code true} if {@link Serializable} was found from input,
     *         {@code false} otherwise
     */
    protected boolean addInterfaces(ObjectModelClass input,
                                    ObjectModelClass output) {
        boolean foundSerializable = false;
        for (ObjectModelInterface parentInterface : input.getInterfaces()) {
            String fqn = parentInterface.getQualifiedName();
            addInterface(output, fqn);
            if (Serializable.class.getName().equals(fqn))  {
                foundSerializable = true;
            }
        }
        return foundSerializable;
    }

    protected void createPropertyChangeSupport(ObjectModelClass output) {

        addAttribute(output,
                     "pcs",
                     PropertyChangeSupport.class,
                     "new PropertyChangeSupport(this)",
                     ObjectModelJavaModifier.PROTECTED,
                     ObjectModelJavaModifier.FINAL,
                     ObjectModelJavaModifier.TRANSIENT
        );

        // Add PropertyListener

        ObjectModelOperation operation;

        operation = addOperation(output,
                                 "addPropertyChangeListener",
                                 "void",
                                 ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, PropertyChangeListener.class, "listener");
        setOperationBody(operation, ""
    +"\n"
+"        pcs.addPropertyChangeListener(listener);\n"
+"    "
        );

        operation = addOperation(output,
                                 "addPropertyChangeListener",
                                 "void",
                                 ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, String.class, "propertyName");
        addParameter(operation, PropertyChangeListener.class, "listener");
        setOperationBody(operation, ""
    +"\n"
+"        pcs.addPropertyChangeListener(propertyName, listener);\n"
+"    "
        );

        operation = addOperation(output,
                                 "removePropertyChangeListener",
                                 "void",
                                 ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, PropertyChangeListener.class, "listener");
        setOperationBody(operation, ""
    +"\n"
+"        pcs.removePropertyChangeListener(listener);\n"
+"    "
        );

        operation = addOperation(output,
                                 "removePropertyChangeListener",
                                 "void",
                                 ObjectModelJavaModifier.PUBLIC
        );
        addParameter(operation, String.class, "propertyName");
        addParameter(operation, PropertyChangeListener.class, "listener");
        setOperationBody(operation, ""
    +"\n"
+"        pcs.removePropertyChangeListener(propertyName, listener);\n"
+"    "
        );

        operation = addOperation(output,
                                 "firePropertyChange",
                                 "void",
                                 ObjectModelJavaModifier.PROTECTED
        );
        addParameter(operation, String.class, "propertyName");
        addParameter(operation, Object.class, "oldValue");
        addParameter(operation, Object.class, "newValue");
        setOperationBody(operation, ""
    +"\n"
+"        pcs.firePropertyChange(propertyName, oldValue, newValue);\n"
+"    "
        );

        operation = addOperation(output,
                                 "firePropertyChange",
                                 "void",
                                 ObjectModelJavaModifier.PROTECTED
        );
        addParameter(operation, String.class, "propertyName");
        addParameter(operation, Object.class, "newValue");
        setOperationBody(operation, ""
    +"\n"
+"        firePropertyChange(propertyName, null, newValue);\n"
+"    "
        );
    }

    protected void createGetChildMethod(ObjectModelClass output) {
        ObjectModelOperation getChild = addOperation(
                output,
                "getChild", "<T> T",
                ObjectModelJavaModifier.PROTECTED
        );
        addImport(output, List.class);

        addParameter(getChild, "java.util.Collection<T>", "childs");
        addParameter(getChild, "int", "index");
        setOperationBody(getChild, ""
+"\n"
+"        T result = null;\n"
+"        if (childs != null) {\n"
+"            if (childs instanceof List) {\n"
+"                if (index < childs.size()) {\n"
+"                    result = ((List<T>) childs).get(index);\n"
+"                }\n"
+"            } else {\n"
+"                int i = 0;\n"
+"                for (T o : childs) {\n"
+"                    if (index == i) {\n"
+"                        result = o;\n"
+"                        break;\n"
+"                    }\n"
+"                    i++;\n"
+"                }\n"
+"            }\n"
+"        }\n"
+"        return result;\n"
+""
        );
    }
}
