/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.utils;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chorem.pollen.business.dto.PollAccountDTO;

import au.com.bytecode.opencsv.bean.ColumnPositionMappingStrategy;
import au.com.bytecode.opencsv.bean.CsvToBean;

/**
 * Classe permettant de gérer l'import de listes de votants au format CSV.
 *
 * @author rannou
 * @version $Id: CSVAccountUtil.java 2896 2010-03-05 09:55:30Z fdesbois $
 */
public class CSVAccountUtil {

    /** log. */
    private static final Log log = LogFactory.getLog(CSVAccountUtil.class);

    /**
     * CSV import from a reader. The CSV file contains three columns
     * corresponding to 'votingId', 'email' and 'weight'.No header column is
     * needed, the separator is ','. Ex : "toto","toto@titi.fr","3"
     *
     * @param reader which contains the input stream
     * @return the new PollAccountDTO list from results imported
     */
    public static List<PollAccountDTO> importList(Reader reader) {
        List<PollAccountDTO> accounts = null;

        // Définition de la stratégie de mapping
        ColumnPositionMappingStrategy<PollAccountDTO> strat =
                new ColumnPositionMappingStrategy<PollAccountDTO>();
        String[] columns = new String[] { "votingId", "email", "weight" };
        strat.setType(PollAccountDTO.class);
        strat.setColumnMapping(columns);

        // Parsing du fichier CSV
        CsvToBean<PollAccountDTO> csv = new CsvToBean<PollAccountDTO>();
        accounts = csv.parse(strat, reader);

        // Suppression des comptes null
        Iterator<PollAccountDTO> it = accounts.iterator();
        while (it.hasNext()) {
            if ("".equals(it.next().getVotingId())) {
                it.remove();
            }
        }

        if (log.isInfoEnabled()) {
            log.info(accounts.size() + " comptes importés.");
        }

        return accounts;
    }

    /**
     * Import d'une liste de votants à partir d'un fichier CSV.
     *
     * @param file le fichier CSV
     * @return a PollAccountDTO list
     * @see #importList(java.io.Reader)
     */
    public static List<PollAccountDTO> importList(UploadedFile file) {
        if (log.isInfoEnabled()) {
            log.info("Import du fichier " + file.getFileName() + " ("
                    + file.getContentType() + ")...");
        }

        InputStreamReader reader = new InputStreamReader(file.getStream());
        return importList(reader);
    }
}
