/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.poll;

import java.io.File;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.ui.components.ImageContextLink;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.services.Configuration;

/**
 * Classe de la page de visualisation d'une image.
 *
 * @author rannou
 * @version $Id: ImageDisplay.java 2856 2010-02-01 17:46:41Z echatellier $
 * 
 * @deprecated not used anymore (displayed by ligthbox now)
 */
public class ImageDisplay {

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    @Inject
    private Messages messages;

    /**
     * Service contenant la configuration de l'application.
     */
    @Inject
    private Configuration conf;

    /** Sondage */
    @Persist
    private PollDTO poll;

    /** Identifiant du choix */
    @Persist
    private String choiceId;

    /** Chaine définissant le style de la page */
    @Persist
    private String pageStyle;

    /** Choix */
    @Property
    private ChoiceDTO choice;

    @InjectComponent
    private ImageContextLink imgContext;

    public ImageContextLink getImgContext() {
        return imgContext;
    }

    public PollDTO getPoll() {
        return poll;
    }

    public void setPoll(PollDTO poll) {
        this.poll = poll;
    }

    public String getChoiceId() {
        return choiceId;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public String getPageStyle() {
        if (pageStyle == null) {
            pageStyle = "Index";
        }
        return pageStyle;
    }

    public void setPageStyle(String pageStyle) {
        this.pageStyle = pageStyle;
    }

    /**
     * Initialisation de la page
     */
    void onActivate() {
        choice = new ChoiceDTO();
        for (ChoiceDTO c : poll.getChoiceDTOs()) {
            if (choiceId.equals(c.getId())) {
                choice = c;
            }
        }
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null), new Lien(messages.get("title2"), null) };
    }

}
