/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.poll;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;

/**
 * Classe de la page de confirmation de la création d'un sondage.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: CreationValidation.java 2658 2009-07-20 13:25:18Z nrannou $
 */
public class CreationValidation {

    /** Affichage des messages pour l'utilisateur */
    @Component(id = "feedback")
    private FeedBack feedback;

    /**
     * Objet de session représentant l'url du site.
     */
    @SuppressWarnings("unused")
    @SessionState
    @Property
    private String siteURL;

    /**
     * Sondage créé
     */
    @Persist
    private PollDTO poll;

    /**
     * Créateur du sondage
     */
    @Property
    private PollAccountDTO creator;

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    /** Localisation */
    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServicePollAccount servicePollAccount;

    /**
     * Retoure le sondage créé
     *
     * @return poll
     */
    public PollDTO getPoll() {
        return poll;
    }

    /**
     * Remplace l'attribut poll
     *
     * @param poll la nouvelle valeur de l'attribut poll
     */
    public void setPoll(PollDTO poll) {
        this.poll = poll;
    }

    /**
     * Récupération de l'identifiant de modification du sondage.
     *
     * @return l'identifiant.
     */
    public String getAdminId() {
        return poll.getPollId() + ":" + creator.getAccountId();
    }

    void onActivate() {
        creator = servicePollAccount.findPollAccountById(poll.getCreatorId());
        feedback.addInfo(messages.get("created"));
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null) };
    }

}
