/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.data;

/**
 * Classe représentant un item de l'adresse dans la classe Border.
 *
 * @author kmorin
 * @version $Id: Lien.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class Lien {

    /**
     * nom sous lequel apparait le lien dans la barre d'adresse.
     */
    private String name;

    /**
     * adresse où mène le lien
     */
    private String address;

    /**
     * Constructeur
     *
     * @param name nom du lien
     * @param address adresse du lien
     */
    public Lien(String name, String address) {
        this.name = name;
        this.address = address;
    }

    /**
     * Retourn le nom du lien
     *
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * Modifie la valeur de name
     *
     * @param name la nouvelle valeur de name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Retourne l'adresse du lien
     *
     * @return address
     */
    public String getAddress() {
        return address;
    }

    /**
     * Modifie l'adresse du lien
     *
     * @param address la nouvelle valeur du lien
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * Renvoie si l'adresse du lien est nulle.
     *
     * @return vrai si l'adresse est nulle
     */
    public boolean isLienNull() {
        return address == null;
    }
}
