/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.services;

import java.util.Properties;

/**
 * Service de gestion de la configuration de l'application. Ce service lit la
 * configuration dans un fichier properties.
 *
 * @author rannou
 * @version $Id: Configuration.java 2868 2010-02-17 17:49:42Z fdesbois $
 */
public interface Configuration {

    public static final String FEED_DIR = "feedDir";
    public static final String IMG_DIR = "upImgDir";
    public static final String PROP_APP_VERSION = "version";
    public static final String PROP_CONTACT_EMAIL = "adminEmail";

    /**
     * Retourne les propriétés.
     *
     * @return les propriétés.
     */
    public Properties getConf();

    /**
     * Change les propriétés.
     *
     * @param conf les propriétés.
     */
    public void setConf(Properties conf);

    /**
     * Retourne une propriété.
     *
     * @param key la clé de la propriété.
     * @return la propriété.
     */
    public String getProperty(String key);

    /**
     * Change une propriété.
     *
     * @param key la clé de la propriété.
     * @param value la valeur de la propriété.
     */
    public void setProperty(String key, String value);
}
